<?php
  //  File: MyDebug.php
  /*  Zawiera kod PHP centralizujcy zbieranie i raportowanie
      wszystkich typw bdw w kodzie PHP.  */

  define( "MYDEBUG_INTERNAL",       0 );
  define( "MYDEBUG_ERRCALLBACK",    1 );
  define( "MYDEBUG_ASSERTCALLBACK", 2 );
  
  define( "MYDEBUG_DISPLAYFILE",    1 );
  define( "MYDEBUG_DISPLAYEMAIL",   2 );
  define( "MYDEBUG_DISPLAYIP",      4 );
  
  function GetPHPErrType( $aErrorNo )
  {
    switch ( $aErrorNo )
    {
      case E_ERROR:
          $aErrorType = "E_ERROR"; // nie powinien wystpi
          break;
      case E_WARNING:
          $aErrorType = "E_WARNING";
          break;
      case E_PARSE:
          $aErrorType = "E_PARSE"; // nie powinien wystpi
          break;
      case E_NOTICE:
          $aErrorType = "E_NOTICE";
          break;
      case E_CORE_ERROR:
          $aErrorType = "E_CORE_ERROR"; // nie powinien wystpi
          break;
      case E_CORE_WARNING:
          $aErrorType = "E_CORE_WARNING"; // nie powinien wystpi
          break;
      case E_COMPILE_ERROR:
          $aErrorType = "E_COMPILE_ERROR"; // nie powinien wystpi
          break;
      case E_COMPILE_WARNING:
          $aErrorType = "E_COMPILE_WARNING"; // nie powinien wystpi
          break;
      case E_USER_ERROR:
          $aErrorType = "E_USER_ERROR";
          break;
      case E_USER_WARNING:
          $aErrorType = "E_USER_WARNING";
          break;
      case E_USER_NOTICE:
          $aErrorType = "E_USER_NOTICE";
          break;
      default:
          $aErrorType = "UNKNOWN";
          break;
    }
    
    return $aErrorType;
  }
  
  // parseConfig przetwarza cig konfiguracyjny
  // i inicjuje zmienne funkcji obsugi
  function ParseConfig( $aConfigStr )
  {
    global $aMyDebugType, $aMyDebugFile, $aMyDebugEmail;
    global $aMyDebugIP, $aMyDebugPort;

    $aConfigArray = explode( ";", $aConfigStr );
    foreach( $aConfigArray as $aItem )
    {
      if ( trim( $aItem != "" ) )
      {
        $aItemArray = explode( "=", $aItem );
        assert( 'count( $aItemArray ) == 2' );
        if ( $aItemArray[1] != "0" )
        {
          switch ( $aItemArray[0] ) 
          {
            case "FILE":
              $aMyDebugType |= MYDEBUG_DISPLAYFILE;
              $aMyDebugFile = $aItemArray[1];
                break;
            case "MAIL":
              $aMyDebugType |= MYDEBUG_DISPLAYEMAIL;
              $aMyDebugEmail = $aItemArray[1];
              break;
            case "IP":
              $aMyDebugType |= MYDEBUG_DISPLAYIP;
              $aIPArray = explode( ":", $aItemArray[1] );
              assert( 'count( $aIPArray ) == 2' );
              $aMyDebugIP = $aIPArray[0];
              $aMyDebugPort = $aIPArray[1];
              break;
            }
        }
      }
    }
  }
  
  function CheckFileSanity( $aFile )
  {
    $aFD = fopen( $aFile, "a" );
    if ( $aFD )
    {
      fclose( $aFD );
      return True;
    }
    return False;
  }
  
  function MyDebugShutdown( )
  {
    global $aFileHandle, $aSocketHandle, $aMyDebugType;
    if ( $aMyDebugType & MYDEBUG_DISPLAYFILE ) 
    {
      fclose( $aFileHandle );
    }

    if ( $aMyDebugType & MYDEBUG_DISPLAYIP ) 
    {
      fclose( $aSocketHandle );
    }
  }

  /*  Funkcja formatuje typ komunikatu w oparciu o to
      gdzie bdzie wywietlony */
  function FormatType( $aCallType, $aDisplayType )
  {
    switch( $aDisplayType )
    {
      case MYDEBUG_DISPLAYFILE:
      case MYDEBUG_DISPLAYEMAIL:
        switch ( $aCallType )
        {
            case MYDEBUG_INTERNAL:
                return "INTERNAL";
                break;
            case MYDEBUG_ERRCALLBACK:
                return "ERROR CALLBACK";
                break;
            case MYDEBUG_ASSERTCALLBACK:
                return "ASSERT CALLBACK";
                break;
        }
        break;
      case MYDEBUG_DISPLAYIP:
        return $aCallType;
        break;
    }
  }
  
  /*  Funkcja formatuje typ komunikatu w oparciu o to
      gdzie bdzie wywietlony i skd zosta wysany*/
  function FormatMsg( $aCallType, $aMessage, $aErrType, $aDisplayType )
  {
    $aPrepend = "";
    if ( $aCallType == MYDEBUG_ERRCALLBACK )
    {
      $aPrepend = "Typ bdu PHP: " . GetPHPErrType( $aErrType ) . " - ";
    }

    return $aPrepend . $aMessage;
  }
  
  /*  Funkcja formatuje typ komunikatu w oparciu o to
      gdzie bdzie wywietlony. Funkcja oparta o
      funkcj rekurencujn FormatContextR */
  function FormatContext( $aErrContext, $aDisplayType )
  {
    // od tej pory wszystkie wywietlane typy 
    // otrzymuja ten sam cig kontekstu
    $aString = "";
    $aDelim  = "\n";
    FormatContextR( $aErrContext, $aString, $aDelim );
    return $aString;
  }
  
  function FormatContextR( $aErrContext, &$aString, $aDelim )
  {
    foreach( $aErrContext as $aVarName => $aVarValue )
    {
      if ( is_array( $aVarValue ) == True ) 
      {
        $aString .= "$aVarName = array( ";
        FormatContextR( $aVarValue, $aString, "," );
        $aString .= " )$aDelim";
      }
      else
      {
        $aString .= "$aVarName = {$aVarValue}{$aDelim}";
      }
    }
  }
  
  //  Funkcja MyDebug jest gwn funkcj obsugi
  function MyDebug( $aMessage, $aFile, $aLine, 
                    $aCallType = MY_DEBUG_INTERNAL, $aErrType = 0,
                    $aErrContext = array() )
  {
    global $aMyDebugType;
    
    for ( $aDisplayType = MYDEBUG_DISPLAYFILE;
          $aDisplayType <= MYDEBUG_DISPLAYIP;
          $aDisplayType++ )
    {
      if ( $aDisplayType & $aMyDebugType )
      {
        $aType      = FormatType( $aCallType, $aDisplayType );
        $aMessage   = FormatMsg ( $aCallType, $aMessage, $aErrType, $aDisplayType );
        
        if ( $aCallType == MYDEBUG_ERRCALLBACK )
        {
            $aContext = FormatContext( $aErrContext, $aDisplayType );
        }
        else
        {
            $aContext = "";
        }
        
        MyDebugOutput( $aType, $aMessage, $aFile, $aLine, $aContext, $aDisplayType );
      }
    }
  }   
  
  function MyDebugOutput( $aType, $aMessage, $aFile, $aLine, $aContext, $aDisplayType )
  {
    global $aFileHandle, $aSocketHandle, $aMyDebugEmail;
    
    switch( $aDisplayType )
    {
      case MYDEBUG_DISPLAYFILE:
        $aMsg = "$aType: '$aMessage' wystpi w $aFile w lini $aLine.  ";
        if ( $aContext != "" )
        {
            $aMsg .= "Dane kontekstu:\n{$aContext}\n";
        }
        else
        {
            $aMsg .= "\n";
        }
        fputs( $aFileHandle, $aMsg );
        break;
      case MYDEBUG_DISPLAYEMAIL:
        $aMsg = "$aType: '$aMessage' wystpi w $aFile w linii $aLine.  ";
        if ( $aContext != "" )
        {
            $aMsg .= "Dane kontekstu:\n{$aContext}\n";
        }
        else
        {
            $aMsg .= "\n";
        }
        mail( $aMyDebugEmail, "Raport MyDebug", $aMsg, "From: mydebug@host.com\r\n" );
        break;
      case MYDEBUG_DISPLAYIP:
        $aMsg = "$aType|$aMessage|$aFile|$aLine|$aContext^^";
        fputs( $aSocketHandle, $aMsg );
        break;
    }
  }
  
  //  Funkcja obsugi ustawiana przez set_error_handler()
  function MyErrHandler( $aErrorNo, $aErrorStr, $aFile, $aLine, $aContext) 
  {
    MyDebug( $aErrorStr, $aFile, $aLine, MYDEBUG_ERRCALLBACK,
             $aErrorNo, $aContext );
  }
  
  //  Funkcja obsugi dla funcji assert_options()
  function MyAssertHandler( $aFileName, $aLineNum, $aAssertion )
  {
    MyDebug( "asercja( $aAssertion ) nieudana", $aFileName, 
             $aLineNum, MYDEBUG_ASSERTCALLBACK );
  }

  /*  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      Ustawianie rodowiska MyDebug.  Zdefinowane zostay zmienne 
      globalne:
          $aMyDebugType  - gdzie bd wywietlane dane 
          $aMyDebugEmail - adres e-mail do wysyania informacji
          $aMyDebugFile  - plik do rejestrowania informacji
          $aMyDebugIP    - ip do wysyania informacji
          $aMyDebugPort  - potr dla ip (powyej)    
          $aFileHandle   - uchwyt pliku z informacjami (jeeli wymagany)
          $aSocketHandle - gniazdo na informacje (jeeli wymagane)
      +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  */
//  ParseConfig( getenv( "MYDEBUG_CONFIG" ) );
getenv( "MYDEBUG_CONFIG" );
echo $MYDEBUG_CONFIG;
ParseConfig( $MYDEBUG_CONFIG );
  if ( $aMyDebugType & MYDEBUG_DISPLAYFILE ) 
  {
      // jeeli nie mona zapisa do pliku sladu 
      // poinformuj o tym uzytkownika i wyczy zapis do pliku
      if ( CheckFileSanity( $aMyDebugFile ) == False )
      {
          error_log( "MyDebug nie udao si otworzy pliku $aMyDebugFile", 0 );
          $aMyDebugType &= ~MYDEBUG_DISPLAYFILE;
      }
  }
  
  if ( $aMyDebugType & MYDEBUG_DISPLAYFILE ) 
  {
      $aFileHandle = fopen( $aMyDebugFile, "a" );
  }

  if ( $aMyDebugType & MYDEBUG_DISPLAYIP ) 
  {
  echo ("socket $aMyDebugPort<BR>");
      $aSocketHandle = fsockopen( "udp://$aMyDebugIP", $aMyDebugPort );
  }
  
  //  Teraz rejestrujemy funkcje obsugi i funkcje porzdkujce
  set_error_handler( "MyErrHandler" );
  assert_options( ASSERT_CALLBACK, "MyAssertHandler" );
  assert_options( ASSERT_WARNING, 0 );
  register_shutdown_function( "MyDebugShutdown" );
?>