unit phpdebugger;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, IdBaseComponent, IdComponent, IdUDPBase, IdUDPServer,
  IdSocketHandle, NMUDP, Grids, ValEdit, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    NMUDP1: TNMUDP;
    lstKomunikaty: TListView;
    btnCzysc: TButton;
    Panel1: TPanel;
    procedure NMUDP1DataReceived(Sender: TComponent; NumberBytes: Integer;
      FromIP: String; Port: Integer);
    procedure AnalizujCiag( Ciag : string );
    function OpisTypu( NrTypu : Integer ) : string;
    procedure btnCzyscClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.NMUDP1DataReceived(Sender: TComponent;
  NumberBytes: Integer; FromIP: String; Port: Integer);
var
  MyStream: TMemoryStream;
  TmpStr: String;
begin
  if NumberBytes > 1 then
  begin
    MyStream := TMemoryStream.Create;
    try
      NMUDP1.ReadStream(MyStream);
      SetLength(TmpStr,NumberBytes);
      MyStream.Read(TmpStr[1],NumberBytes);
    finally
      MyStream.Free;
    end;
    AnalizujCiag ( TmpStr );
  end;
end;


procedure TForm1.AnalizujCiag ( Ciag : string );
var
  ciagtyp, plik, linia, komunikat : string;
  poz : integer;
  it : TListItem;
begin
  poz := pos( '|', ciag );
  ciagtyp := copy( ciag, 1, poz - 1);
  ciag := copy( ciag, poz+1, length(ciag));

  poz := pos( '|', ciag );
  komunikat := copy( ciag, 1, poz - 1);
  ciag := copy( ciag, poz+1, length(ciag));

  poz := pos( '|', ciag );
  plik := copy( ciag, 1, poz - 1);
  ciag := copy( ciag, poz+1, length(ciag));

  poz := pos( '|', ciag );
  linia := copy( ciag, 1, poz - 1);
  ciag := copy( ciag, poz+1, length(ciag));

  it := lstKomunikaty.Items.Add ;
  it.Caption := OpisTypu (StrToInt(ciagtyp));
  it.SubItems.Add(plik);
  it.SubItems.Add(linia);
  it.SubItems.Add(komunikat);

end;

function TForm1.OpisTypu(NrTypu : integer ) : string;
begin
  result := '';
  case NrTypu of
    0: result := 'INTERNAL';
    1: result := 'ERROR CALLBACK';
    2: result := 'ASSERT CALLBACK';
  end;
end;

procedure TForm1.btnCzyscClick(Sender: TObject);
begin
  lstKomunikaty.Items.Clear ;
end;

end.
