<?php
   // Plik: MyAuthOrcl_CustForm.php.
   require_once 'HTML/QuickForm.php';
   // Pobranie klasy Auth, aby moga zosta rozszerzona.
   require_once 'Auth.php';
   class MyAuthOrcl_CustForm extends Auth
   {
      protected $auth_default_options = array(
         'cryptType'=>'none',
      );
      public function __construct ($arr)
      {
         function login_function($username, $status)
         {
            $headerTemplate  = '<tr><td style="background-color:
               #dddddd;" align="center" colspan="2"><font
               face="Arial"><i>{header}</i></font></td></tr>';
            $elementTemplate  = '<tr><td align="right"><font
               face="Arial"><!-- Pocztek wymaganego kodu. --><span
               style="color: #ff0000">*</span>';
            $elementTemplate  .= '<!-- Koniec wymaganego kodu. -->
               {label}</font></td><td align="left">{element}</td></tr>';
            $form=new HTML_QuickForm('login', 'POST');
            $renderer = $form->defaultRenderer();
            $renderer->setHeaderTemplate($headerTemplate);
            $renderer->setElementTemplate($elementTemplate);
            $header='Prosz poda dane uwierzytelniajce';
            switch ($status) {
               case -1: $header='Wystpi zbyt dugi okres bezczynnoci.
                  Prosz zalogowa si ponownie.';
                  break;
               case -2: $header='Sesja wygasa. Prosz zalogowa si ponownie.';
                  break;
               case -3: $header='Podano nieprawidowe dane. Prosz sprbowa ponownie.';
                  break;
            }
            $form->addElement('header',null,$header );
            $form->addElement('text','username','Nazwa uytkownika:');
            $form->addRule('username','Podanie nazwy uytkownika jest
               wymagane!','required', null, 'client');
            $form->addElement('password','password','Haso:');
            $form->addRule('password','Podanie hasa jest
               wymagane!','required', null, 'client');
            $form->addElement('submit','submit','Zaloguj si!');
            $form->display();
         }
         $auth_options = array_merge($this->auth_default_options, $arr);
         $auth_options['usernamecol'] =
            strtoupper($auth_options['usernamecol']);
         $auth_options['passwordcol'] =
            strtoupper($auth_options['passwordcol']);
         parent::__construct('DB',$auth_options, 'login_function');
      }
   }
?>
