<?php # Listing 18.10 - forgot_password.php
// Ten skrypt pozwala zresetować hasło, jeśli użytkownik go zapomni.
require('includes/config.inc.php');
$page_title = 'Zapomniane hasło';
include('includes/naglowek.html');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
  require(MYSQL);

  // żadnych założeń...
  $uid = FALSE;

  // sprawdzamy adres e-mail
  if (!empty($_POST['email'])) {

    // sprawdzamy czy podany adres e-mail istnieje
    $q = 'SELECT user_id FROM users WHERE email="'.  mysqli_real_escape_string($dbc, $_POST['email']) . '"';
    $r = mysqli_query($dbc, $q) or trigger_error("Polecenie SQL: $q\n<br>Błąd MySQL: " . mysqli_error($dbc));

    if (mysqli_num_rows($r) == 1) { // pobieramy id użytkownika
      list($uid) = mysqli_fetch_array($r, MYSQLI_NUM);
    } else { // nie znaleziono adresu e-mail
      echo '<p class="error">Podany adres e-mail nie jest zarejestrowany w bazie!</p>';
    }

  } else { // nie podano adresu e-mail
    echo '<p class="error">Nie podałeś adresu e-mail!</p>';
  } // koniec instrukcji IF empty($_POST['email']) 

  if ($uid) { // wszystko jest OK

    // tworzymy nowe, losowe hasło
    $p = substr(md5(uniqid(rand(), true)), 3, 15);
    $ph = password_hash($p, PASSWORD_DEFAULT);

    // aktualizujemy bazę danych
    $q = "UPDATE users SET pass='$ph' WHERE user_id=$uid LIMIT 1";
    $r = mysqli_query($dbc, $q) or trigger_error("Polecenie SQL: $q\n<br>Błąd MySQL: " . mysqli_error($dbc));

    if (mysqli_affected_rows($dbc) == 1) { // operacja wykonana prawidłowo

      // wywyłamy wiadomość e-mail z informacją
      $body = "Twoje hasło logowania do witryny <jakis sajt> zostało tymczasowo zmienione na '$p'. Zaloguj się, używając tego hasła i swojego adresu e-mail. Po zalogowaniu się będziesz mógł zmienić hasło na dowolne inne.";
      mail($_POST['email'], 'Twoje tymczasowe hasło.', $body, 'From: admin@jakissajt.pl');

      // wyświetlamy komunikat i kończymy
      echo '<h3>Twoje hasło zostało zmienione. Nowe, tymczasowe hasło zostało wysłane pocztą elektroniczną na podany adres. Po zalogowaniu się z użyciem tego hasła, będziesz mógł je zmienić klikając łącze "Zmiana hasła"</h3>';
      mysqli_close($dbc);
      include('includes/stopka.html');
      exit(); // kończymy działanie skryptu

    } else { // nie udało się zmodyfikować bazy
      echo '<p class="error">Nie udało się zmienić hasła ze względu na błąd systemu. Przepraszamy za niedogodności.</p>';
    }

  } else { // błędy walidacji danych
    echo '<p class="error">Proszę spróbować jeszcze raz.</p>';
  }

  mysqli_close($dbc);

} // koniec głównej instrukcji warunkowej
?>

<h1>Resetowanie hasła</h1>
<p>Podaj swój adres poczty elektronicznej, a hasło zostanie zresetowane.</p>
<form action="forgot_password.php" method="post">
  <fieldset>
  <p><strong>Adres e-mail:</strong> <input type="email" name="email" size="20" maxlength="60" value="<?php if (isset($_POST['email'])) echo $_POST['email']; ?>"></p>
  </fieldset>
  <div align="center"><input type="submit" name="submit" value="Zresetuj moje hasło"></div>
</form>

<?php include('includes/stopka.html'); ?>