<?php # Listing 18.11 - change_password.php
// Ten skrypt pozwala zalogowanemu użytkownikowi zmienić swoje hasło.
require('includes/config.inc.php');
$page_title = 'Zmiana hasła';
include('includes/naglowek.html');

// jeśli w sesji nie istnieje zmienna user_id, przekierowujemy użytkownika
if (!isset($_SESSION['user_id'])) {

  $url = BASE_URL . 'index.php'; // definiujemy adres URL
  ob_end_clean(); // czyścimy bufor wyjściowy
  header("Location: $url");
  exit(); // kończymy działanie skryptu

}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
  require(MYSQL);

  // sprawdzamy nowe hasło oraz czy hasło zostało poprawnie powtórzone
  $p = FALSE;
  if (strlen($_POST['password1']) >= 10) {
    if ($_POST['password1'] == $_POST['password2']) {
      $p = password_hash($_POST['password1'], PASSWORD_DEFAULT);
    } else {
      echo '<p class="error">Należy dwukrotnie wpisać to samo hasło!</p>';
    }
  } else {
    echo '<p class="error">Wpisz prawidłowe hasło!</p>';
  }

  if ($p) { // jeśli wszystko jest OK...

    // wykonujemy polecenie
    $q = "UPDATE users SET pass='$p' WHERE user_id={$_SESSION['user_id']} LIMIT 1";
    $r = mysqli_query($dbc, $q) or trigger_error("Polecenie SQL: $q\n<br>Błąd MySQL: " . mysqli_error($dbc));
    if (mysqli_affected_rows($dbc) == 1) { // jeśli polecenie wykonano poprawnie

      // tu można także wysyłać wiadomość e-mail
      echo '<h3>Twoje hasło zostało zmienione.</h3>';
      mysqli_close($dbc); // zamykamy połączenie z bazą danych
      include('includes/stopka.html'); // dołączamy stopkę
      exit();

    } else { // jeśli nie udało się wykonać polecenia

      echo '<p class="error">Nie udało się zmienić hasła. Upewnij się, że nowe hasło różni się od aktualnego. Jeśli sądzisz, że wystąpił błąd, skontaktuj się z administratorem.</p>';

    }

  } else { // błąd walidacji danych
    echo '<p class="error">Spróbuj jeszcze raz.</p>';
  }

  mysqli_close($dbc); // zamykamy połączenie z bazą danych

} // koniec głównej instrukcji warunkowej
?>

<h1>Zmiana hasła</h1>
<form action="change_password.php" method="post">
  <fieldset>
  <p><strong>Nowe hasło:</strong> <input type="password" name="password1" size="20"> <small>musi mieć co najmniej 10 znaków długości.</small></p>
  <p><strong>Powtórz nowe hasło:</strong> <input type="password" name="password2" size="20"></p>
  </fieldset>
  <div align="center"><input type="submit" name="submit" value="Zmiana hasła"></div>
</form>

<?php include('includes/stopka.html'); ?>