<!doctype html>
<html lang="pl">
<head>
  <meta charset="utf-8">
  <title>Przesyłanie dokumentu RTF na serwer</title>
</head>
<body>
<?php # Listing 13.3 - wyslij_rtf.php

// sprawdzamy czy formularz został przesłany
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  // sprawdzamy czy został przesłany plik
  if (isset($_FILES['upload']) && file_exists($_FILES['upload']['tmp_name'])) {

    // sprawedzamy typ pliku, powinien to być plik RTF;
    // tworzymy zasób
    $fileinfo = finfo_open(FILEINFO_MIME_TYPE);

    // sprawdzamy plik
    if (finfo_file($fileinfo, $_FILES['upload']['tmp_name']) == 'text/rtf') {

      // informujemy, że wszystko idzie dobrze!
      echo '<p><em>Plik może zostać zapisany na serwerze!</em></p>';

      // w praktyce tu powinniśmy przenieść plik w miejsce docelowe, w tym skrypciek ograniczymy się do jego usunięcia
      unlink($_FILES['upload']['tmp_name']);

    } else { // niewłaściwy typ pliku
      echo '<p style="font-weight: bold; color: #C00">Proszę przesłać dokument RTF.</p>';
    }

    // zamykamy zasób:
    finfo_close($fileinfo);

  } // koniec instrukcji IF isset($_FILES['upload'])

  // w razie konieczności dodaj tu obsługę błędów związanych z przesyłaniem pliku

} // koniec głównej instrukcji warunkowej
?>

<form enctype="multipart/form-data" action="wyslij_rtf.php" method="post">
  <input type="hidden" name="MAX_FILE_SIZE" value="524288">
  <fieldset><legend>Wybierz plik RTF o wielkości do 512 KB, który chcesz przesłać na serwer:</legend>
  <p><strong>Plik:</strong> <input type="file" name="upload"></p>
  </fieldset>
  <div align="center"><input type="submit" name="submit" value="Wyślij"></div>
</form>
</body>
</html>