<?php # Listing 17.6 - post_form.php
// Ten skrypt wyświetla formularz do dodawania wiadomości.
// Zawsze jest on dołączany do innych stron, a nie wyświetlany bezpośrednio.

// przekierowujemy jeśli strona została wyświetlona bezpośrednio
if (!isset($words)) {
  header ("Location: http://www.jakissajt.pl/index.php");
  exit();
}

// formularz wyświetlamy jedynie gdy użytkownik jest zalogowany
if (isset($_SESSION['user_id'])) {

  // wyświetlamy formularz
  echo '<form action="post.php" method="post" accept-charset="utf-8">';

  // jeśli jesteśmy na stronie read.php...
  if (isset($tid) && $tid) {

    // wyświetlamy tytuł
    echo '<h3>' . $words['post_a_reply'] . '</h3>';

    // dodajemy identyfikator wątku do pola ukrytego
    echo '<input name="tid" type="hidden" value="' . $tid . '">';

  } else { // nowy wątek

    // wyświetlamy tytuł
    echo '<h3>' . $words['new_thread'] . '</h3>';

    // tworzymy pole do podania tematu
    echo '<div class="form-group"><label for="subject">' . $words['subject'] . '</label> <input name="subject" type="text" class="form-control" size="60" maxlength="100" ';

    // sprawdzamy czy wartość już istnieje
    if (isset($subject)) {
      echo "value=\"$subject\" ";
    }

    echo '></div>';

  } // koniec instrukcji IF $tid.

  // tworzymy wielowierszowy obszar tekstowy
  echo '<div class="form-group"><label for="subject">' . $words['body'] . '</label> <textarea name="body" class="form-control" rows="10" cols="60">';

  if (isset($body)) {
    echo $body;
  }

  echo '</textarea></div>';

  // kończymy formularz
  echo '<input name="submit" type="submit" class="form-control" value="' . $words['submit'] . '">
  </form>';

} else {
  echo '<p class="bg-warning">Musisz być zalogowany, aby móc publikować wiadomości.</p>';
}

?>