<!doctype html>
<html lang="pl">
<head>
  <meta charset="utf-8">
  <title>Wstaw wiadomość</title>
</head>
<body>
<?php # Listing 16.4 - wstaw_wiadomosc.php #2
// To jest obiektowa wersja skryptu z rozdziału 13.

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  // weryfikacja danych (pominięta)!

  // nawiązujemy połączenie z bazą danych
  $mysqli = new MySQLi('localhost', 'username', 'password', 'forum');
  $mysqli->set_charset('utf8');

  // generujemy polecenie SQL
  $q = 'INSERT INTO messages (forum_id, parent_id, user_id, subject, body, date_entered) VALUES (?, ?, ?, ?, ?, NOW())';

  // przygotowujemy polecenie
  $stmt = $mysqli->prepare($q);

  // dowiązujemy wartości do polecenia
  $stmt->bind_param('iiiss', $forum_id, $parent_id, $user_id, $subject, $body);

  // ustawiamy wartości zmiennych
  $forum_id = (int) $_POST['forum_id'];
  $parent_id = (int) $_POST['parent_id'];
  $user_id = 3; // w normalny skrypcie wartość zmiennej $user_id byłaby odczytywana z sesji
  $subject = strip_tags($_POST['subject']);
  $body = strip_tags($_POST['body']);

  // wykonujemy zapytanie
  $stmt->execute();

  // wyświetlamy komunikat zależnie do tego czy wystąpiły błędy czy nie
  if ($stmt->affected_rows == 1) {
    echo '<p>Twoja wiadomość została opublikowana.</p>';
  } else {
    echo '<p style="font-weight: bold; color: #C00">Nie udało się opublikować twojej wiadomości..</p>';
    echo '<p>' . mysqli_stmt_error($stmt) . '</p>';
  }

  // zamykamy polecenie
  $stmt->close();
  unset($stmt);

  // zamykamy połączenie z bazą danych
  $mysqli->close();
  unset($mysqli);

} // koniec głównej instrukcji IF

// wyświetlamy formularz
?>
<form action="wstaw_wiadomosc.php" method="post">

  <fieldset><legend>Wstaw nową wiadomość:</legend>

  <p><strong>Temat</strong>: <input name="subject" type="text" size="30" maxlength="100"></p>

  <p><strong>Treść</strong>: <textarea name="body" rows="3" cols="40"></textarea></p>

  </fieldset>
  <div align="center"><input type="submit" name="submit" value="Wstaw"></div>
  <input type="hidden" name="forum_id" value="1">
  <input type="hidden" name="parent_id" value="0">

</form>
</body>
</html>