// Listing 15.7 - kalkulator.js #2
// Ten skrypt jest dołączany przez stronę kalkulator.html.
// Obsługuje on kontrolę danych i obliczenie wyników po przesłaniu formularza.

// wykonujemy operacje po zakończeniu wczytywania dokumentu
$(function() {

  // ukrywamy wszystkie komunikaty o błędach
  $('.errorMessage').hide();

  // określamy procedurę obsługi zdarzenia przesłania formularza
  $('#calculator').submit(function() {

    // inizjalizujemy zmienne
    var quantity, price, tax, total;

    // sprawdzamy poprawność pola liczby egzemplarzy
    if ($('#quantity').val() > 0) {

      // pobieramy wartość pola
      quantity = $('#quantity').val();

      // czyścimy błąd, jeśli istnieje
      $('#quantityP').removeClass('error');

      // ukrywamy komunikat o błędzie, jeśli jest widoczny
      $('#quantityError').hide();

    } else { // liczba egzemplarzy jest nieprawidłowa

      // dodajemy klasę błędu
      $('#quantityP').addClass('error');

      // wyświetlamy komunikat błędu
      $('#quantityError').show();

    }

    // sprawdzamy poprawność pola ceny
    if ($('#price').val() > 0) {
      price = $('#price').val();
      $('#priceP').removeClass('error');
      $('#priceError').hide();
    } else {
      $('#priceP').addClass('error');
      $('#priceError').show();
    }

    // sprawdzamy poprawność pola podatku
    if ($('#tax').val() > 0) {
      tax = $('#tax').val();
      $('#taxP').removeClass('error');
      $('#taxError').hide();
    } else {
      $('#taxP').addClass('error');
      $('#taxError').show();
    }

    // jeśli dane są prawidłowe, wykonujemy obliczenia
    if (quantity && price && tax) {

      total = quantity * price;
      total += total * (tax/100);

      // wyświetlamy wyniki
      $('#results').html('Kwota zakupu wynosi: <strong>' + total + ' zł</strong>.');
    }

    // zwracamy false, by formularz nie został przesłany na serwer
    return false;

  }); // koniec obsługi zdarzenia submit

}); // koniec funkcji document ready