<?php # Listing 12.12 - login.php #4
// Skrypt obsługujący formularz logowania.
// Ta wersja skryptu poprawia bezpieczeństwo zapisując w sesji wartość HTTP_USER_AGENT

// sprawdzamy czy formularz został przesłany
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  // dołączamy dwa pliki pomocnicze
  require('includes/login_functions.inc.php');
  require('../mysqli_connect.php');

  // próbujemy zalogować użytkownik
  list ($check, $data) = check_login($dbc, $_POST['email'], $_POST['pass']);

  if ($check) { // OK!

    // zapisujemy dane w sesji
    session_start();
    $_SESSION['user_id'] = $data['user_id'];
    $_SESSION['first_name'] = $data['first_name'];

    // zapisujemy w sesji także wartość HTTP_USER_AGENT:
    $_SESSION['agent'] = sha1($_SERVER['HTTP_USER_AGENT']);

    // przekierowanie
    redirect_user('loggedin.php');

  } else { // niepowodzenie

    // zapisujemy $data w $errors, by przekazać błędy na stronę login_page.inc.php
    $errors = $data;

  }

  mysqli_close($dbc); // zamykamy połączenie z bazą danych

} // koniec głównej instrukcji warunkowej

// tworzymy stronę
include('includes/login_page.inc.php');
?>