<?php # Listing 3.10 - kalkulator.php #5

// Ta funkcja tworzy przycisk opcji.
// Ma ona dwa argumenty, value i name; dodatkowo
// pozwala "zapamiętać" wartość pól.
function create_radio($value, $name='fuel_price') {

  // Rozpoczynamy generowanie elementu:
  echo '<input type="radio" name="'. $name .'" value="' . $value . '"';

  // Sprawdzamy czy jest poprzednia wartość:
  if (isset($_POST[$name]) && ($_POST[$name] == $value)) {
    echo ' checked="checked"';
  }

  // Kończymy generowanie elementu:
  echo "> $value ";

} // Koniec funkcji create_fuel_radio().

// Funkcja obliczająca koszty podróży samochodowej.
// Funkcja pobiera trzy argumenty: dystans, wydajność zużycia paliwa, cenę za litr paliwa.
// Funkcja zwraca wyliczony koszt podróży.
function calculate_trip_cost($km, $kmpl, $ppg) {

  // Wyliczamy ilość paliwa:
  $liters = $km/$kmpl;

  // Na podstawie ilości paliwa obliczamy jego koszt:
  $cost = $liters * $ppg;

  // Zwracamy prawidłowo sformatowany koszt podróży:
  return number_format($cost, 2);

} // Koniec funkcji calculate_trip_cost().

$page_title = 'Kalkulator kosztów podróży!';
include ('includes/naglowek.html');

// Sprawdzamy czy formularz został wysłany.
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  // Bardzo prosta weryfikacja danych z formularza:
  if (isset($_POST['distance'], $_POST['fuel_price'], $_POST['efficiency']) && 
   is_numeric($_POST['distance']) && is_numeric($_POST['fuel_price']) && is_numeric($_POST['efficiency']) ) {

    // Wyliczamy wyniki:
    $cost = calculate_trip_cost($_POST['distance'], $_POST['efficiency'], $_POST['fuel_price']);
    $hours = $_POST['distance']/75;

    // Wyświetlamy wyniki:
    echo '<div class="page-header"><h1>Szacunkowy koszt całkowity</h1></div>
    <p>Całkowity koszt przejechania ' . $_POST['distance'] . ' kilometrów, przy średnim zużyciu ' . $_POST['efficiency'] . ' kilometrów na litr i przy średniej cenie ' . $_POST['fuel_price'] . ' zł za litr, wynosi ' . $cost . ' zł. Gdybyś jechał z prędkością 75 kilometrów na godzinę, podróż zajęłaby około ' . number_format($hours, 2) . ' godzin.</p>';

  } else { // Przesłano nieprawidłowe dane.
    echo '<div class="page-header"><h1>Błąd!</h1></div>
    <p class="text-danger">Proszę prawidłowo podać dystans oraz wybrać cenę paliwa i jego zużycie.</p>';
  }

} // Koniec obsługi formularza IF.

// Koniec sekcji PHP i początek formularza HTML:
?>

<div class="page-header"><h1>Kalkulator kosztów podróży</h1></div>
<form action="kalkulator.php" method="post">
  <p>Dystans (w kilometrach): <input type="number" name="distance"  value="<?php if (isset($_POST['distance'])) echo $_POST['distance']; ?>"></p>
  <p>Średnia cena za litr paliwa:
  <?php 
    create_radio('4.50');
    create_radio('4.65');
    create_radio('4.80');
  ?>
  </p>
  <p>Zużycie paliwa: <select name="efficiency">
    <option value="12.5" <?php if (isset($_POST['efficiency']) && ($_POST['efficiency'] == '12.5')) echo ' selected="selected"'; ?>>Duże</option>
    <option value="14.2" <?php if (isset($_POST['efficiency']) && ($_POST['efficiency'] == '14.2')) echo ' selected="selected"'; ?>>Przeciętne</option>
    <option value="16.6" <?php if (isset($_POST['efficiency']) && ($_POST['efficiency'] == '16.6')) echo ' selected="selected"'; ?>>Niskie</option>
    <option value="20"   <?php if (isset($_POST['efficiency']) && ($_POST['efficiency'] == '20')) echo ' selected="selected"'; ?>>Rewelacyjne</option> 
  </select></p>
  <p><input type="submit" name="submit" value="Oblicz!"></p>
</form>

<?php include ('includes/stopka.html'); ?>