<!doctype html>
<html lang="pl">
<head>
  <meta charset="utf-8">
  <title>Transfer środków</title>
</head>
<body>
<h1>Transfer środków</h1>
<?php # Listing 11.7 - transfer.php
// Ta strona wykonuje przekaz środków z jednego konta na inne.
// Skrypt używa transakcji.

// połączenie z bazą danych jest niezbędne, zawsze
$dbc = mysqli_connect('localhost', 'root', 'password', 'banking') OR die('Nie można nawiązać połączenia z serwerem MySQL: ' . mysqli_connect_error() );

// sprawdzay czy formularz został przesłany
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  // najprostsza z możliwych weryfikacja formularza
  if (isset($_POST['from'], $_POST['to'], $_POST['amount']) &&
   is_numeric($_POST['from']) && is_numeric($_POST['to']) && is_numeric($_POST['amount']) ) {

    $from = $_POST['from'];
    $to = $_POST['to'];
    $amount = $_POST['amount'];

    // upewniamy się czy na koncie źródłowym jest dostatecznie dużo środków
    $q = "SELECT balance FROM accounts WHERE account_id=$from";
    $r = @mysqli_query($dbc, $q);
    $row = mysqli_fetch_array($r, MYSQLI_ASSOC);
    if ($amount > $row['balance']) {
      echo '<p class="error">Brak środków niezbędnych do wykonania operacji.</p>';
    } else {
      // wyłączamy automatyczne zatwierdzanie transakcji
      mysqli_autocommit($dbc, FALSE);
      $q = "UPDATE accounts SET balance=balance-$amount WHERE account_id=$from";
      $r = @mysqli_query($dbc, $q);
      if (mysqli_affected_rows($dbc) == 1) { // polecenie wykonane poprawnie

        $q = "UPDATE accounts SET balance=balance+$amount WHERE account_id=$to";
        $r = @mysqli_query($dbc, $q);
        if (mysqli_affected_rows($dbc) == 1) { // polecenie wykonane poprawnie

          mysqli_commit($dbc);
          echo '<p>Środki zostały prawidłowo przelane!</p>';

        } else {
          mysqli_rollback($dbc);
          echo '<p>Nie udało się wykonać przelewu ze względu na błąd systemu. Przepraszamy za utrudnienia.</p>'; // komunikat publiczny
          echo '<p>' . mysqli_error($dbc) . '<br>Polecenie: ' . $q . '</p>'; // komunikat do debugowania
        }

      } else {
        mysqli_rollback($dbc);
        echo '<p>Nie udało się wykonać przelewu ze względu na błąd systemu. Przepraszamy za utrudnienia.</p>'; // komunikat publiczny
        echo '<p>' . mysqli_error($dbc) . '<br>Polecenie: ' . $q . '</p>'; // komunikat do debugowania
      }

    }

  } else { // przesłane wartości są nieprawidłowe
    echo '<p class="error">Proszę wybrać odpowiednie konto źródłowe i docelowe, a następnie wpisać kwotę przelewu (jako liczbę).</p>';
  }

} // koniec instrukcji if obsługującej przesłanie formularza

// standardowo wyświetlamy formularz

// pobieramy wszystkie konta oraz ich stan, aby wyświetlić w formie opcji na liście
$q = "SELECT account_id, CONCAT(last_name, ', ', first_name) AS name, type, balance FROM accounts LEFT JOIN customers USING (customer_id) ORDER BY name";
$r = @mysqli_query($dbc, $q);
$options = '';
while ($row = mysqli_fetch_array($r, MYSQLI_ASSOC)) {
  $options .= "<option value=\"{$row['account_id']}\">{$row['name']} ({$row['type']}) \${$row['balance']}</option>\n";
}

// tworzymy formularz:
echo '<form action="transfer.php" method="post">
<p>Konto źródłowe: <select name="from">' . $options . '</select></p>
<p>Konto docelowe: <select name="to">' . $options . '</select></p>
<p>Kwota przekazu: <input type="number" name="amount" step="0.01" min="1"></p>
<p><input type="submit" name="submit" value="Przekaż"></p>
</form>';

mysqli_close($dbc);
?>
</body>
</html>