<?php // convert.php
  $f = $c = '';

  if (isset($_POST['f'])) $f = sanitizeString($_POST['f']);
  if (isset($_POST['c'])) $c = sanitizeString($_POST['c']);

  if (is_numeric($f))
  {
    $c = intval((5 / 9) * ($f - 32));
    $out = "$f &deg;f odpowiada $c &deg;c";
  }
  elseif(is_numeric($c))
  {
    $f = intval((9 / 5) * $c + 32);
    $out = "$c &deg;c odpowiada $f &deg;f";
  }
  else $out = "";

  echo <<<_END
<html>
  <head>
    <meta charset="utf-8">
    <title>Przelicznik temperatur</title>
  </head>
  <body>
    <pre>
      Podaj temperaturę w stopniach Fahrenheita albo Celsjusza i kliknij przycisk Przelicz
        
      <b>$out</b>
      <form method="post" action="">
         Fahrenheit <input type="text" name="f" size="7">
           Celsjusz <input type="text" name="c" size="7">
                    <input type="submit" value="Przelicz">
      </form>
    </pre>
  </body>
</html>
_END;

  function sanitizeString($var)
  {
    if (get_magic_quotes_gpc())
      $var = stripslashes($var);
    $var = strip_tags($var);
    $var = htmlentities($var);
    return $var;
  }
?>
