<?php
declare(strict_types = 1);                               // Włącz ścisłą kontrolę typów
use PhpMysql\Weryfikacja\Weryfikacja;                    // Zaimportuj klasę Weryfikacja

$uczestnik = [];                                         // Zainicjalizuj tablicę $uczestnik
$bledy = [];                                             // Zainicjalizuj tablicę $bledy

if ($_SERVER['REQUEST_METHOD'] == 'POST') {              // Jeśli formularz został przesłany
    // Pobierz dane z formularza
    $uczestnik['imie']     = $_POST['imie'];             // Pobierz imię
    $uczestnik['nazwisko'] = $_POST['nazwisko'];         // Pobierz nazwisko
    $uczestnik['email']    = $_POST['email'];            // Pobierz e-mail
    $uczestnik['haslo']    = $_POST['haslo'];            // Pobierz hasło
    $potwierdzenie         = $_POST['potwierdzenie'];    // Pobierz potwierdzenie hasła

    // Skontroluj dane z formularza
    $bledy['imie'] = Weryfikacja::czyTekst($uczestnik['imie'], 1, 254)
        ? '' : 'Imię musi mieć 1-254 znaków';
    $bledy['nazwisko']  = Weryfikacja::czyTekst($uczestnik['nazwisko'], 1, 254)
        ? '' : 'Nazwisko musi mieć 1-254 nazwisko';
    $bledy['email']    = Weryfikacja::czyEmail($uczestnik['email'])
        ? '' : 'Proszę podać prawidłowy e-mail';
    $bledy['haslo'] = Weryfikacja::czyHaslo($uczestnik['haslo'])
        ? '' : 'Hasło musi się składać z co najmniej 8 znaków, w tym:<br> 
                Małej litery<br>Dużej litery<br>Cyfry
                <br>Znaku specjalnego';
    $bledy['potwierdzenie']  = ($uczestnik['haslo'] = $potwierdzenie)
        ? '' : 'Niezgodne hasła';
    $nieprawidlowe           = implode($bledy);                    // Połącz komunikaty błędów

    if (!$nieprawidlowe) {                                         // Jeśli nie ma błędów
        $rezultat = $cms->pobierzUczestnika()->utworz($uczestnik); // Utwórz użytkownika
        if ($rezultat === false) {                                 // Jeśli $rezultat ma wartość false
            $bledy['email'] = 'Podany e-mail jest już w bazie';    // Zapisz ostrzeżenie
        } else {                                                   // W przeciwnym razie przekieruj do logowania
            przekieruj('logowanie/', ['sukces'=>'Dziękujemy za rejestrację! Zaloguj się.']);
        }
    }
}

$dane['nawigacja'] = $cms->pobierzKategorie()->pobierzWszystko();  // Wszystkie kategorie do nawigacji
$dane['uczestnik'] = $uczestnik;                                   // Dane użytkownika
$dane['bledy']     = $bledy;                                       // Komunikaty błędów

echo $twig->render('rejestracja.html', $dane);                     // Wyrenderuj szablon