<?php
use PhpMysql\Weryfikacja\Weryfikacja;                    // Zaimportuj przestrzeń Weryfikacja
czyAdmin($sesja->rola);                                  // Sprawdź status administratora

$publikacja = [];                                        // Zainicjalizuj tablicę $publikacja
$bledy  = [];                                           // Zainicjalizuj tablicę błędów

if (!$id) {                                              // Jeśli nie ma id
    przekieruj('admin/publikacje/', ['niepowodzenie' => 'Nie odnaleziono publikacji']); // Przekieruj
}

$publikacja = $cms->pobierzPublikacje()->pobierz($id, false);  // Pobierz publikację
if (!$publikacja) {                                            // Jeśli nie ma publikacji
    przekieruj('admin/publikacje/', ['niepowodzenie' => 'Nie odnaleziono publikacji']); // Przekieruj
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                    // Jeśli formularz został przesłany
    $publikacja['obraz_alt'] = $_POST['obraz_alt'];            // Pobierz tekst zastępczy

    $bledy['alt'] = (Weryfikacja::czyTekst($publikacja['obraz_alt'], 1, 254))
        ? '' : 'Tekst zastępczy musi mieć 1-254 znaków.';      // Sprawdź tekst zastępczy

    if ($bledy['alt']) {                                       // Jeśli nie jest prawidłowy
        $bledy['ostrzezenie'] = 'Prosimy o poprawienie błędu'; // Zapisz komunikat błędu
    } else {
        $cms->pobierzPublikacje()->aktualizujAlt($publikacja['id_obrazu'], $publikacja['obraz_alt']); // Zmiana tekstu zastępczego
        przekieruj('admin/publikacje/' . $id);                 // Powrót do strony publikacji
    }

}
$dane['publikacja'] = $publikacja;
$dane['bledy']  = $bledy;

echo $twig->render('admin/edytuj-alt.html', $dane);   // Wyrenderuj szablon