<?php
namespace PhpMysql\CMS;                               // Deklaracja przestrzeni nazw

class Komentarz
{                                                     // Definicja klasy Komentarz
    protected $db;                                    // Zawiera odwołanie do obiektu Baza

    public function __construct(Baza $db)             // Uruchamia się przy tworzeniu obiektu tej klasy
    {
        $this->db = $db;                              // Przechowaj obiekt Baza we właściwości $db
    }

    // Pobierz wszystkie komentarze do publikacji
    public function pobierzWszystko(int $id): array
    {
        $sql = "SELECT k.id, k.komentarz, k.zamieszczono,
               CONCAT(u.imie, ' ', u.nazwisko) AS autor, u.zdjecie
                 FROM komentarze AS k
                 JOIN uczestnicy AS u ON k.id_uczestnika = u.id 
                WHERE k.id_publikacji = :id;";                         // Instrukcja SQL
        return $this->db->wykonajSQL($sql, ['id' => $id])->fetchAll(); // Wykonaj instrukcję
    }

    // Dodaj komentarz do publikacji
    public function utworz(array $komentarz): bool
    {
        $sql = "INSERT INTO komentarze (komentarz, id_publikacji, id_uczestnika) 
                VALUES (:komentarz, :id_publikacji, :id_uczestnika);"; // Instrukcja SQL
        $this->db->wykonajSQL($sql, $komentarz);                       // Wykonaj instrukcję
        return true;
    }

}