<?php
declare(strict_types = 1);                                        // Użyj ścisłej kontroli typów
include '../src/bootstrap.php';                                   // Plik konfiguracyjny

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);         // Sprawdź id
if (!$id) {                                                       // Jeśli nie ma prawidłowego id
    include APP_ROOT . '/public/nie-odnaleziono-strony.php';      // Nie odnaleziono strony
}

$publikacja = $cms->pobierzPublikacje()->pobierz($id);            // Pobierz dane o publikacji
if (!$publikacja) {                                               // Jeśli tablica $publikacja jest pusta
    include APP_ROOT . '/public/nie-odnaleziono-strony.php';      // Nie odnaleziono strony
}

$dane['nawigacja'] = $cms->pobierzKategorie()->pobierzWszystko(); // Pobierz kategorie
$dane['publikacja'] = $publikacja;                                // Publikacja
$dane['sekcja']     = $publikacja['id_kategorii'];                // Bieżąca kategoria

echo $twig->render('publikacja.html', $dane);                     // Wyrenderuj szablon