<?php
declare(strict_types = 1);                                  // Włącz ścisłą kontrolę typów
use PhpMysql\Weryfikacja\Weryfikacja;                       // Zaimportuj klasę Weryfikacja

include '../src/bootstrap.php';                             // Plik konfiguracyjny
$od    = '';                                                // Zainicjalizuj nadawcę
$wiadomosc = '';                                            // Wiadomość
$bledy  = [];                                               // Tablica na błędy
$sukces = '';                                               // Komunikat o powodzeniu

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                 // Jeśli formularz został przesłany
    $od               = $_POST['email'];                    // Adres e-mail
    $wiadomosc        = $_POST['wiadomosc'];                // Wiadomość
    $bledy['email']   = Weryfikacja::czyEmail($od)            ? '' : 'Nieprawidłowy adres e-mail';
    $bledy['wiadomosc'] = Weryfikacja::czyTekst($wiadomosc, 1, 1000) ? '' : 'Proszę wprowadzić wiadomość do 1000 znaków';
    $nieprawidlowe = implode($bledy);                       // Połącz komunikaty błędów
    if ($nieprawidlowe) {                                   // W razie błędów
        $bledy['ostrzezenie'] = 'Proszę sprawdzić błędy w formularzu';    // Wyświetl ostrzeżenie
    } else {                                                // W przeciwnym razie spróbuj wysłać
        $temat = "Wiadomość od " . $od;                     // Utwórz temat wiadomości
        $email   = new \PhpMysql\Email\Email($ustaw_email); // Utwórz obiekt Email
        $email->wyslijEmail($ustaw_email['admin_email'], $ustaw_email['admin_email'],  
          $temat, $wiadomosc);                              // Wyślij
        $sukces = 'Twoja wiadomość została wysłana';        // Komunikat o powodzeniu
    }
}
$dane['nawigacja'] = $cms->pobierzKategorie()->pobierzWszystko();  // Wszystkie kategorie do nawigacji

// Poniższe wartości są tworzone tylko po przesłaniu formularza
$dane['od']        = $od;                                   // Adres nadawcy
$dane['wiadomosc'] = $wiadomosc;                            // Wiadomość
$dane['bledy']     = $bledy;                                // Komunikaty błędów
$dane['sukces']    = $sukces;                               // Komunikat o powodzeniu

echo $twig->render('kontakt.html', $dane);                  // Wyrenderuj szablon