<?php
declare(strict_types=1);                                  // Użyj ścisłej kontroli typów
include '../src/bootstrap.php';                           // Plik konfiguracyjny

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT); // Sprawdź id
if (!$id) {                                               // Jeśli nie ma prawidłowego id
    include APP_ROOT . '/public/nie-odnaleziono-strony.php';  // Nie odnaleziono strony
}

$publikacja = $cms->pobierzPublikacje()->pobierz($id);        // Pobierz dane publikacji
if (!$publikacja) {                                           // Jeśli tablica $publikacja jest pusta
    include APP_ROOT . '/public/nie-odnaleziono-strony.php';  // Nie odnaleziono strony
}

$nawigacja  = $cms->pobierzKategorie()->pobierzWszystko();    // Pobierz kategorie
$sekcja     = $publikacja['id_kategorii'];                    // Bieżąca kategoria
$tytul       = $publikacja['tytul'];                          // Treść elementu HTML <title>
$opis = $publikacja['podsumowanie'];                          // Treść opisu meta
?>
<?php include APP_ROOT . '/public/dolaczane/naglowek.php'; ?>
  <main class="article container" id="content">
    <section class="image">
      <img src="wyslane/<?= zastap_html($publikacja['obraz_plik'] ?? 'blank.png') ?>" 
           alt="<?= zastap_html($publikacja['obraz_alt']) ?>">
    </section>
    <section class="text">
      <h1><?= zastap_html($publikacja['tytul']) ?></h1>
      <div class="date"><?= formatuj_date($publikacja['utworzono']) ?></div>
      <div class="content"><?= zastap_html($publikacja['tresc']) ?></div>
      <p class="credit">
        Zamieszczono w <a href="kategoria.php?id=<?= $publikacja['id_kategorii'] ?>"><?= zastap_html($publikacja['kategoria']) ?></a> przez: <a href="uczestnik.php?id=<?= $publikacja['id_uczestnika'] ?>">
          <?= zastap_html($publikacja['autor']) ?></a>
      </p>
    </section>
  </main>
<?php include APP_ROOT . '/public/dolaczane/stopka.php'; ?>