<?php
// CZĘŚĆ A: Przygotowanie
declare(strict_types = 1);                                  // Użyj ścisłej kontroli typów
require '../dolaczane/polaczenie-baza.php';                 // Połączenie z bazą
require '../dolaczane/funkcje.php';                         // Dołącz funkcje
include '../dolaczane/weryfikacja.php';                     // Dołącz kontrolę danych
// Ustawienia przesyłania plików
$wyslane = dirname(__DIR__, 1) . DIRECTORY_SEPARATOR . 'wyslane' . DIRECTORY_SEPARATOR; // Folder z plikami obrazów
$typy_plikow      = ['image/jpeg', 'image/png', 'image/gif',];      // Dozwolone typy plików
$rozszerzenia_plikow = ['jpg', 'jpeg', 'png', 'gif',];              // Dozwolone rozszerzenia
$max_rozmiar        = '5242880';                                    // Maksymalny rozmiar pliku

// Inicjalizacja zmiennych potrzebnych w kodzie PHP
$id          = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);  // Pobierz i sprawdź id
$tymcz       = $_FILES['obraz']['tmp_name'] ?? '';                  // Obraz tymczasowy
$cel = '';                                                          // Miejsce zapisania pliku

// Inicjalizacja zmiennych potrzebnych w kodzie HTML
$publikacja = [
    'id'            => $id,
    'tytul'         => '',
    'podsumowanie'  => '',
    'tresc'         => '',
    'id_uczestnika' => 0,
    'id_kategorii'  => 0,
    'id_obrazu'     => null,
    'opublikowano'  => false,
    'obraz_plik'    => '',
    'obraz_alt'     => '',
];                                                                  // Dane publikacji
$bledy  = [
    'ostrzezenie'   => '',
    'tytul'         => '',
    'podsumowanie'  => '',
    'tresc'         => '',
    'autor'         => '',
    'kategoria'     => '',
    'obraz_plik'    => '',
    'obraz_alt'     => '',
];                                                                  // Komunikaty błędów

// Jeśli podany został id, strona edytuje publikację, pobierz więc jej dane
if ($id) {                                                          // Jeśli jest id
    $sql     = "SELECT p.id, p.tytul, p.podsumowanie, p.tresc,  
                       p.id_kategorii, p.id_uczestnika, p.id_obrazu, p.opublikowano,
                       o.plik      AS obraz_plik,
                       o.alt       AS obraz_alt 
                  FROM publikacje  AS p
                  LEFT JOIN obrazy AS o ON p.id_obrazu = o.id
                 WHERE p.id = :id;";                                // Zaptanie SQL o publikację
    $publikacja = pdo($pdo, $sql, [$id])->fetch();                  // Pobierz dane publikacji

    if (!$publikacja) {                                             // Jeśli publikacja jest pusta
        przekieruj('publikacje.php', ['niepowodzenie' => 'Nie znaleziono publikacji']); // Przekieruj
    }
}

$zapisany_obraz = $publikacja['obraz_plik'] ? true : false;         // Czy zdjęcie zostało przesłane

// Pobierz wszystkich uczestników i wszystkie kategorie
$sql     = "SELECT id, imie, nazwisko FROM uczestnicy;";            // Zapytanie SQL o wszystkich uczestników
$autorzy = pdo($pdo, $sql)->fetchAll();                             // Pobierz wszystkich uczestników

$sql        = "SELECT id, nazwa FROM kategorie;";                   // Zapytanie SQL o wszystkie kategorie
$kategorie = pdo($pdo, $sql)->fetchAll();                           // Pobierz wszystkie kategorie


// CZĘŚĆ B: Pobierz i sprawdź dane z formularza
if ($_SERVER['REQUEST_METHOD'] == 'POST') {                         // Jeśli formularz został przesłany
    // Jeśli plik jest większy niż ograniczenia w php.ini lub .htaccess zapisz komunikat błędu
	    $bledy['obraz_plik'] = ($tymcz and $_FILES['obraz']['error'] === 1) ? 'Plik jest za duży ' : '';
    // Jeśli obraz został przesłany, pobierz dane i sprawdź
    if ($tymcz and $_FILES['obraz']['error'] === 0) {               // Jeśli plik został przesłany bez błędów
        $publikacja['obraz_alt'] = $_POST['obraz_alt'];             // Pobierz tekst zastępczy (alt)

        // Zweryfikuj plik obrazu
        $bledy['obraz_plik'] = in_array(mime_content_type($tymcz), $typy_plikow)
            ? '' : 'Nieobsługiwany typ pliku. ';                            // Sprawdź typ pliku
        $rozszerzenie = strtolower(pathinfo($_FILES['obraz']['name'], PATHINFO_EXTENSION)); // Rozszerzenie pliku małymi literami
        $bledy['obraz_plik'] .= in_array($rozszerzenie, $rozszerzenia_plikow)
            ? '' : 'Nieobsługiwane rozszerzenie. ';                         // Sprawdź rozszerzenie
        $bledy['obraz_plik'] .= ($_FILES['obraz']['size'] <= $max_rozmiar)
            ? '' : 'Plik jest za duży. ';                                   // Sprawdź rozmiar
        $bledy['obraz_alt']  = (czy_tekst($publikacja['obraz_alt'], 1, 254))
            ? '' : 'Tekst zastępczy musi mieć 1-254 znaków.';               // Sprawdź tekst zastępczy

        // Jeśli plik z obrazem jest prawidłowy, określ miejsce zapisu
        if ($bledy['obraz_plik'] === '' and $bledy['obraz_alt'] === '') {   // Jeśli prawidłowy
            $publikacja['obraz_plik'] = utworz_nazwepliku($_FILES['obraz']['name'], $wyslane);
            $cel = $wyslane . $publikacja['obraz_plik'];                    // Miejsce docelowe
        }
    }

    // Pobierz dane publikacji
    $publikacja['tytul']         = $_POST['tytul'];                 // Tytuł
    $publikacja['podsumowanie']  = $_POST['podsumowanie'];          // Streszczenie
    $publikacja['tresc']         = $_POST['tresc'];                 // Treść
    $publikacja['id_uczestnika'] = $_POST['id_uczestnika'];         // Autor
    $publikacja['id_kategorii']  = $_POST['id_kategorii'];          // Kategoria
    $publikacja['opublikowano']  = (isset($_POST['opublikowano']) and ($_POST['opublikowano'] == 1)) ? 1 : 0;   // Czy opublikowano?

    // Zweryfikuj dane publikacji i utwórz komunikaty w razie błędów
    $bledy['tytul']    = czy_tekst($publikacja['tytul'], 1, 80)
        ? '' : 'Tytuł musi mieć 1-80 znaków';
    $bledy['podsumowanie']  = czy_tekst($publikacja['podsumowanie'], 1, 254)
        ? '' : 'Podsumowanie musi mieć 1-254 znaków';
    $bledy['tresc']  = czy_tekst($publikacja['tresc'], 1, 100000)
        ? '' : 'Publikacja musi mieć 1-100 000 znaków';
    $bledy['uczestnik']   = czy_id_uczestnika($publikacja['id_uczestnika'], $autorzy)
        ? '' : 'Proszę wybrać autora';
    $bledy['kategoria'] = czy_id_kategorii($publikacja['id_kategorii'], $kategorie)
        ? '' : 'Proszę wybrać kategorię';

    $nieprawidlowe = implode($bledy);                                 // Połącz błędy

    // CZĘŚĆ C: Jeśli dane są poprawne, zaktualizuj bazę
    if ($nieprawidlowe) {                                             // Jeśli niepoprawne
        $bledy['ostrzezenie'] = 'Prosimy o poprawienie błędów';       // Zapisz komunikat
    } else {                                                          // W przeciwnym razie
        $argumenty = $publikacja;                                     // Zapisz dane w tablicy $argumenty
        try {                                                         // Spróbuj wstawić dane
            $pdo->beginTransaction();                                 // Rozpocznij transakcję
            if ($cel) {                                               // Jeśli obraz jest prawidłowy
                // Kadrowanie i zapisywanie obrazu
                $imagick = new \Imagick($tymcz);                       // Obiekt reprezentujący obraz
                $imagick->cropThumbnailImage(1200, 700);              // Utwórz wykadrowany obraz
                $imagick->writeImage($cel);                           // Zapisz plik

                $sql = "INSERT INTO obrazy (plik, alt) 
                        VALUES (:plik, :alt);";                       // Instrukcja SQL wstawiająca obraz

                // Wykonaj instrukcję SQL, aby dodać obraz do tabeli
                pdo($pdo, $sql, [$argumenty['obraz_plik'], $argumenty['obraz_alt'],]); 
                $argumenty['id_obrazu'] = $pdo->lastInsertId();       // Pobierz id nowego obrazu
            }
            unset($argumenty['obraz_plik'], $argumenty['obraz_alt']); // Usuń dane o obrazie

            if ($id) {
                $sql = "UPDATE publikacje
                           SET tytul = :tytul, podsumowanie = :podsumowanie, tresc = :tresc,
                               id_kategorii = :id_kategorii, id_uczestnika = :id_uczestnika, 
                               id_obrazu = :id_obrazu, opublikowano = :opublikowano 
                         WHERE id = :id;";                            // Instrukcja SQL aktualizująca publikację
            } else {
                unset($argumenty['id']);                              // Usuń id
                $sql = "INSERT INTO publikacje (tytul, podsumowanie, tresc, id_kategorii, 
                                    id_uczestnika, id_obrazu, opublikowano)
                             VALUES (:tytul, :podsumowanie, :tresc, :id_kategorii, :id_uczestnika,  
                                    :id_obrazu, :opublikowano);";     // Instrkcja SQL tworząca publikację
            }

            // Uruchomienie powyższego zapytania SQL może mieć trojakie skutki:
            // Zapisanie publikacji | Tytuł jest już w użyciu | Wyrzucenie wyjątku z innego powodu
            pdo($pdo, $sql, $argumenty);                         // Wykonaj SQL, aby dodać publikację
            $pdo->commit();                                      // Zatwierdź zmiany
            przekieruj('publikacje.php', ['sukces' => 'Publikacja zapisana']); // Przekieruj
        } catch (Exception $e) {                                 // W razie wyrzucenia wyjątku
            $pdo->rollBack();                                    // Cofnij zmiany SQL
            if (file_exists($cel)) {                             // Jeśli plik obrazu istnieje
                unlink($cel);                                    // Usuń go
            }
            // W razie wyrzucenia wyjątku PDOException dotyczącego naruszenia integralności danych
            if (($e instanceof PDOException) and ($e->errorInfo[1] === 1062)) { 
                $bledy['ostrzezenie'] = 'Istnieje już publikacja o takim tytule'; // Zapisz ostrzezenie
            } else {                                             // W przeciwnym razie
                throw $e;                                        // Ponownie wyrzuć wyjątek
            }
        }
    }
    $publikacja['obraz_plik'] = $zapisany_obraz ? $publikacja['obraz_plik'] : '';
}
?>
<?php include '../dolaczane/admin-naglowek.php'; ?>

<!-- CZĘŚĆ D: Formularz -->
  <form action="publikacja.php?id=<?= $id ?>" method="POST" enctype="multipart/form-data">
    <main class="container admin" id="content">

      <h1>Edytowanie publikacji</h1>
      <?php if ($bledy['ostrzezenie']) { ?>
        <div class="alert alert-danger"><?= $bledy['ostrzezenie'] ?></div>
      <?php } ?>

      <div class="admin-article">
        <section class="image">
          <?php if (!$publikacja['obraz_plik']) { ?>
            <label for="obraz">Prześlij obraz:</label>
            <div class="form-group image-placeholder">
              <input type="file" name="obraz" class="form-control-file" id="obraz"><br>
              <span class="errors"><?= $bledy['obraz_plik'] ?></span>
            </div>
            <div class="form-group">
              <label for="obraz_alt">Tekst zastępczy (alt): </label>
              <input type="text" name="obraz_alt" id="obraz_alt" value="" class="form-control">
              <span class="errors"><?= $bledy['obraz_alt'] ?></span>
            </div>
          <?php } else { ?>
            <label>Obraz:</label>
            <img src="../wyslane/<?= zastap_html($publikacja['obraz_plik']) ?>"
                 alt="<?= zastap_html($publikacja['obraz_alt']) ?>">
            <p class="alt"><strong>Tekst zastępczy (alt):</strong> <?= zastap_html($publikacja['obraz_alt']) ?></p>
            <a href="edytuj-alt.php?id=<?= $publikacja['id'] ?>" class="btn btn-secondary">Edytuj tekst zastępczy</a>
            <a href="usun-obraz.php?id=<?= $id ?>" class="btn btn-secondary">Usuń obraz</a><br><br>
          <?php } ?>
        </section>

        <section class="text">
          <div class="form-group">
            <label for="tytul">Tytuł: </label>
            <input type="text" name="tytul" id="tytul" value="<?= zastap_html($publikacja['tytul']) ?>"
                   class="form-control">
            <span class="errors"><?= $bledy['tytul'] ?></span>
          </div>
          <div class="form-group">
            <label for="podsumowanie">Podsumowanie: </label>
            <textarea name="podsumowanie" id="podsumowanie"
                      class="form-control"><?= zastap_html($publikacja['podsumowanie']) ?></textarea>
            <span class="errors"><?= $bledy['podsumowanie'] ?></span>
          </div>
          <div class="form-group">
            <label for="tresc">Treść: </label>
            <textarea name="tresc" id="tresc"
                      class="form-control"><?= zastap_html($publikacja['tresc']) ?></textarea>
            <span class="errors"><?= $bledy['tresc'] ?></span>
          </div>
          <div class="form-group">
            <label for="id_uczestnika">Autor: </label>
            <select name="id_uczestnika" id="id_uczestnika">
              <?php foreach ($autorzy as $autor) { ?>
                <option value="<?= $autor['id'] ?>"
                    <?= ($publikacja['id_uczestnika'] == $autor['id']) ? 'selected' : ''; ?>>
                    <?= zastap_html($autor['imie'] . ' ' . $autor['nazwisko']) ?></option>
              <?php } ?>
            </select>
            <span class="errors"><?= $bledy['autor'] ?></span>
          </div>
          <div class="form-group">
            <label for="kategoria">Kategoria: </label>
            <select name="id_kategorii" id="kategoria">
              <?php foreach ($kategorie as $kategoria) { ?>
                <option value="<?= $kategoria['id'] ?>"
                    <?= ($publikacja['id_kategorii'] == $kategoria['id']) ? 'selected' : ''; ?>>
                    <?= zastap_html($kategoria['nazwa']) ?></option>
              <?php } ?>
            </select>
            <span class="errors"><?= $bledy['kategoria'] ?></span>
          </div>
          <div class="form-check">
            <input type="checkbox" name="opublikowano" value="1" class="form-check-input" id="opublikowano"
                <?= ($publikacja['opublikowano'] == 1) ? 'checked' : ''; ?>>
            <label for="opublikowano" class="form-check-label">Opublikowano</label>
          </div>
          <input type="submit" name="update" value="Zapisz" class="btn btn-primary">
        </section><!-- /.tekst -->
      </div><!-- /.admin-publikacja -->
    </main>
  </form>
<?php include '../dolaczane/admin-stopka.php'; ?>