<?php
declare(strict_types = 1);
$uzytkownik = '';
$komunikat  = '';

function czy_tekst($tekst, int $min = 0, int $max = 1000): bool
{
    $dlugosc = mb_strlen($tekst);
    return ($dlugosc >= $min and $dlugosc <= $max);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $uzytkownik = $_POST['uzytkownik'];
    $valid    = czy_tekst($uzytkownik, 3, 18);
    if ($valid) {
        $komunikat = 'Nazwa użytkownika jest prawidłowa';
    } else {
        $komunikat = 'Nazwa użytkownika powinna mieć od 3 do 18 znaków';
    }
}
?>
<?php include 'dolaczane/naglowek.php'; ?>

<?= $komunikat ?>
<form action="sprawdzanie-dlugosci-tekstu.php" method="POST">
  Użytkownik: <input type="text" name="uzytkownik"
                   value="<?= htmlspecialchars($uzytkownik) ?>">
  <input type="submit" value="Zapisz">
</form>

<?php include 'dolaczane/stopka.php'; ?>