<?php
declare(strict_types = 1);                                    // Włącz ścisłą kontrolę typów
include '../../src/bootstrap.php';                            // Dołącz plik konfiguracyjny
czyAdmin($sesja->rola);                                       // Sprawdź status administratora
$usunieto = null;                                             // Czy publikacja została usunięta?

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);     // Sprawdź id
if (!$id) {                                                   // Jeśli nie ma id
    przekieruj('admin/publikacje.php', ['niepowodzenie' => 'Nie odnaleziono publikacji']); // Przekieruj z błędem
}

$publikacja = $cms->pobierzPublikacje()->pobierz($id, false); // Pobierz publikację
if (!$publikacja) {                                           // Jeśli nie ma publikacji
    przekieruj('admin/publikacje.php', ['niepowodzenie' => 'Nie odnaleziono publikacji']); // Przekieruj z błędem
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                   // Jeśli formularz został przesłany
    if (isset($publikacja['id_obrazu'])) {                    // Jeśli istnieje obraz
        $sciezka = APP_ROOT . '/public/wyslane/' . $publikacja['obraz_plik']; // Określ ścieżkę do pliku z obrazem
        $cms->pobierzPublikacje()->usunObraz($publikacja['id_obrazu'], $sciezka, $id); // Usuń obraz
    }
    $usunieto = $cms->pobierzPublikacje()->usun($id);         // Usuń publikację
    if ($usunieto === true) {                                 // Jeśli usunięta
        przekieruj('admin/publikacje.php', ['sukces' => 'Publikacja została usunięta']); // Przekieruj
    } else {                                                  // W przeciwnym razie
        throw new Exception('Nie udało się usunąć publikacji');  // Wyrzuć wyjątek
    }
}

$dane['publikacja'] = $publikacja;                            // Publikacja

echo $twig->render('admin/usun-publikacje.html', $dane);      // Wyrenderuj szablon