<?php
// CZĘŚĆ A: Konfiguracja
declare(strict_types=1);                                 // Użyj ścisłej kontroli typów
use PhpMysql\Weryfikacja\Weryfikacja;                    // Zaimportuj przestrzeń nazw Weryfikacja

include '../../src/bootstrap.php';                       // Plik konfiguracyjny

// Inicjalizacja zmiennych potrzebnych w kodzie PHP
$id          = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT); // Pobierz i sprawdź id
$tymcz        = $_FILES['obraz']['tmp_name'] ?? '';      // Tymczasowy obraz
$cel = '';                                               // Miejsce zapisania obrazu
$zapisano       = null;                                  // Czy publikacja została zapisana?

// Inicjalizacja zmiennych potrzebnych w kodzie HTML
$publikacja = [
    'id'          => $id,
    'tytul'       => '',
    'podsumowanie'     => '',
    'tresc'     => '',
    'id_uczestnika'   => 0,
    'id_kategorii' => 0,
    'id_obrazu'    => null,
    'opublikowano'   => false,
    'obraz_plik'  => '',
    'obraz_alt'   => '',
];                                                       // Dane publikacji
$bledy  = [
    'ostrzezenie'     => '',
    'tytul'       => '',
    'podsumowanie'     => '',
    'tresc'     => '',
    'autor'      => '',
    'kategoria'    => '',
    'obraz_plik'  => '',
    'obraz_alt'   => '',
];                                                       // Komunikaty błędów

if ($id) {                                               // Jeśli id jest prawidłowy
    $publikacja = $cms->pobierzPublikacje()->pobierz($id, false);   // Pobierz dane o publikacji
    if (!$publikacja) {                                  // Jeśli nie ma publikacji
        przekieruj('admin/publikacje.php', ['niepowodzenie' => 'Publikacji nie odnaleziono']); // Przekieruj
    }
}

$zapisany_obraz = $publikacja['obraz_plik'] ? true : false;         // Czy obraz został przesłany?
$autorzy    = $cms->pobierzUczestnika()->pobierzWszystko();         // Pobierz wszystkich uczestników
$kategorie = $cms->pobierzKategorie()->pobierzWszystko();           // Pobierz kategorie

// CZĘŚĆ B: Pobierz i sprawdź dane z formularza
if ($_SERVER['REQUEST_METHOD'] == 'POST') {                         // Jeśli formularz został przesłany
    // Jeśli plik jest większy niż ograniczenia w php.ini lub .htaccess zapisz komunikat błędu
    $bledy['obraz_plik'] = ($tymcz and $_FILES['obraz']['error'] === 1) ? 'Plik jest za duży ' : '';

    // Jeśli obraz został przesłany, pobierz dane i sprawdź
    if ($tymcz and $_FILES['obraz']['error'] == 0) {                // Sprawdź plik
        $publikacja['obraz_alt']  = $_POST['obraz_alt'];            // Pobierz tekst zastępczy

        // Zweryfikuj plik obrazu
        $bledy['obraz_plik'] = in_array(mime_content_type($tymcz), TYPY_MIME)
            ? '' : 'Nieobsługiwany typ pliku. ';                    // Sprawdź typ pliku
        $rozszerzenie = strtolower(pathinfo($_FILES['obraz']['name'], PATHINFO_EXTENSION)); // Rozszerzenie pliku małymi literami
        $bledy['obraz_plik'] .= in_array($rozszerzenie, ROZSZERZENIA)
            ? '' : 'Nieobsługiwane rozszerzenie. ';                 // Sprawdź rozszerzenie
        $bledy['obraz_plik'] .= ($_FILES['obraz']['size'] <= MAX_ROZMIAR)
            ? '' : 'Plik jest za duży. ';                           // Sprawdź rozmiar
        $bledy['obraz_alt']  = (Weryfikacja::czyTekst($publikacja['obraz_alt'], 1, 254))
            ? '' : 'Tekst zastępczy musi mieć 1-254 znaków.';       // Sprawdź tekst zastępczy

        // Jeśli plik z obrazem jest prawidłowy, określ miejsce zapisu
        if ($bledy['obraz_plik'] === '' and $bledy['obraz_alt'] === '') { // Jeśli prawidłowy
            $publikacja['obraz_plik'] = utworz_nazwepliku($_FILES['obraz']['name'], WYSLANE);
            $cel = WYSLANE . $publikacja['obraz_plik'];             // Miejsce docelowe
        }
    }

    // Pobierz dane publikacji
    $publikacja['tytul']         = $_POST['tytul'];                 // Tytuł
    $publikacja['podsumowanie']  = $_POST['podsumowanie'];          // Streszczenie
    $publikacja['tresc']         = $_POST['tresc'];                 // Treść
    $publikacja['id_uczestnika'] = $_POST['id_uczestnika'];         // Autor
    $publikacja['id_kategorii']  = $_POST['id_kategorii'];          // Kategoria
    $publikacja['opublikowano']  = (isset($_POST['opublikowano'])) ? 1 : 0; // Czy opublikowano?

    $purifier = new HTMLPurifier();                                 // Utwórz obiekt Purifier
    $purifier->config->set('HTML.Allowed', 'p,br,strong,em,a[href],img[src|alt]'); // Dozwolone znaczniki i atrybuty
    $publikacja['tresc'] = $purifier->purify($publikacja['tresc']);   // Oczyść treść

    // Zweryfikuj dane publikacji i utwórz komunikaty w razie błędów
    $bledy['tytul']    = Weryfikacja::czyTekst($publikacja['tytul'], 1, 80)
        ? '' : 'Tytuł musi mieć 1-80 znaków.';            // Weryfikacja tytułu
    $bledy['podsumowanie']  = Weryfikacja::czyTekst($publikacja['podsumowanie'], 1, 254)
        ? '' : 'Podsumowanie musi mieć 1-254 znaków.';    // Weryfikacja podsumowania
    $bledy['tresc']  = Weryfikacja::czyTekst($publikacja['tresc'], 1, 100000)
        ? '' : 'Publikacja musi mieć 1-100 000 znaków.';  // Weryfikacja treści
    $bledy['uczestnik']   = Weryfikacja::czyIdUczestnika($publikacja['id_uczestnika'], $autorzy)
        ? '' : 'Proszę wybrać autora';                    // Weryfikacja autora
    $bledy['kategoria'] = Weryfikacja::czyIdKategorii($publikacja['id_kategorii'], $kategorie)
        ? '' : 'Proszę wybrać kateogrię';                 // Weryfikacja kategorii

    $nieprawidlowe = implode($bledy);

    // CZĘŚĆ C: Jeśli dane są poprawne, zaktualizuj bazę
    if ($nieprawidlowe) {                                                 // Jeśli niepoprawne
        $bledy['ostrzezenie'] = 'Prosimy o poprawienie błędów';           // Zapisz komunikat
    } else {                                                              // W przeciwnym razie
        $argumenty = $publikacja;                                         // Zapisz dane w tablicy $argumenty
        if ($id) {                                                        // Jeśli id istnieje, aktualizuj
            $zapisano = $cms->pobierzPublikacje()->aktualizuj($argumenty, $tymcz, $cel); // Aktualizuj publikację
        } else {                                                          // Jeśli nie ma id, utwórz
            unset($argumenty['id']);                                      // Usuń id z argumentów
            $zapisano = $cms->pobierzPublikacje()->utworz($argumenty, $tymcz, $cel); // Utwórz publikację
        }

        if ($zapisano == true) {                                          // Jeśli zaktualizowano
            przekieruj('admin/publikacje.php', ['sukces' => 'Publikacja zapisana']); // Przekieruj
        } else {                                                          // W przeciwnym razie
            $bledy['ostrzezenie'] = 'Istnieje już publikacja o takim tytule';        // Zapisz komunikat
        }
    }
    $publikacja['obraz_plik'] = $zapisany_obraz ? $publikacja['obraz_plik'] : '';
}

$dane['publikacja'] = $publikacja;
$dane['kategorie']  = $kategorie;
$dane['autorzy']    = $autorzy;
$dane['bledy']      = $bledy;

echo $twig->render('admin/publikacja.html', $dane);         // Wyrenderuj szablon Twiga