<?php
declare(strict_types=1);                                 // Użyj ścisłej kontroli typów
include '../src/bootstrap.php';                          // Plik konfiguracyjny

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);// Sprawdź id
if (!$id) {                                              // Jeśli nie ma prawidłowego id
    include APP_ROOT . '/public/nie-odnaleziono-strony.php';     // Nie odnaleziono strony
}

$uczestnik = $cms->pobierzUczestnika()->pobierz($id);            // Pobierz dane uczestnika
if (!$uczestnik) {                                               // Jeśli tablica jest pusta
    include APP_ROOT . '/public/nie-odnaleziono-strony.php';     // Nie odnaleziono strony
}

$publikacje = $cms->pobierzPublikacje()->pobierzWszystko(true, null, $id); // Pobierz publikacje uczestnika

$nawigacja  = $cms->pobierzKategorie()->pobierzWszystko();                 // Pobierz kategorie
$sekcja     =                    '';                                       // Bieżąca kategoria
$tytul       = $uczestnik['imie'] . ' ' . $uczestnik['nazwisko'];          // Treść elementu HTML <title>
$opis = $tytul . ' w Creative Folk';                                       // Treść opisu meta
?>
<?php include APP_ROOT . '/public/dolaczane/naglowek.php'; ?>
  <main class="container" id="content">
    <section class="header">
      <h1><?= zastap_html($uczestnik['imie'] . ' ' . $uczestnik['nazwisko']) ?></h1>
      <p class="uczestnik"><b>Uczestniczy od:</b> <?= formatuj_date($uczestnik['dolaczyl']) ?></p>
      <img src="wyslane/<?= zastap_html($uczestnik['zdjecie'] ?? 'uczestnik.png') ?>"
           alt="<?= zastap_html($uczestnik['imie']) ?>" class="profile"><br>
    </section>
    <section class="grid">
    <?php foreach ($publikacje as $publikacja) { ?>
      <article class="summary">
        <a href="publikacja.php?id=<?= $publikacja['id'] ?>">
          <img src="wyslane/<?= zastap_html($publikacja['obraz_plik'] ?? 'blank.png') ?>"
               alt="<?= zastap_html($publikacja['obraz_alt']) ?>">
          <h2><?= zastap_html($publikacja['tytul']) ?></h2>
          <p><?= zastap_html($publikacja['podsumowanie']) ?></p>
        </a>
        <p class="credit">
          Zamieszczone w <a href="kategoria.php?id=<?= $article['id_kategorii'] ?>">
          <?= zastap_html($publikacja['kategoria']) ?></a>
          przez: <a href="uczestnik.php?id=<?= $publikacja['id_uczestnika'] ?>">
          <?= zastap_html($publikacja['autor']) ?></a>
        </p>
      </article>
    <?php } ?>
    </section>
  </main>
<?php include APP_ROOT . '/public/dolaczane/stopka.php'; ?>