<?php
declare(strict_types=1);                                 // Użyj ścisłej kontroli typów
include '../src/bootstrap.php';                          // Plik konfiguracyjny

$publikacje    = $cms->pobierzPublikacje()->pobierzWszystko(true, null, null, 6); // Get latest article summaries

$nawigacja  = $cms->pobierzKategorie()->pobierzWszystko();            // Pobierz kategorie
$sekcja     = '';                                        // Bieżąca kategoria
$tytul      = 'Creative Folk';                           // Treść elementu HTML <title>
$opis       = 'Kreatywne umysły do wynajęcia';           // Treść opisu meta
?>
<?php include APP_ROOT . '/public/dolaczane/naglowek.php'; ?>
  <main class="container grid" id="content">
    <?php foreach ($publikacje as $publikacja) { ?>
      <article class="summary">
        <a href="publikacja.php?id=<?= $publikacja['id'] ?>">
          <img src="wyslane/<?= zastap_html($publikacja['obraz_plik'] ?? 'blank.png') ?>"
               alt="<?= zastap_html($publikacja['obraz_alt']) ?>">
          <h2><?= zastap_html($publikacja['tytul']) ?></h2>
          <p><?= zastap_html($publikacja['podsumowanie']) ?></p>
        </a>
        <p class="credit">
          Zamieszczono w <a href="kategoria.php?id=<?= $publikacja['id_kategorii'] ?>">
          <?= zastap_html($publikacja['kategoria']) ?></a>
          przez: <a href="uczestnik.php?id=<?= $publikacja['id_uczestnika'] ?>">
          <?= zastap_html($publikacja['autor']) ?></a>
        </p>
      </article>
    <?php } ?>
  </main>
<?php include APP_ROOT . '/public/dolaczane/stopka.php'; ?>