<?php
declare(strict_types = 1);                                 // Włącz ścisłą kontrolę typów

if (!$id) {                                                // Jeśli nie ma prawidłowego id
    include APP_ROOT . '/src/strony/nie-odnaleziono-strony.php';    // Nie odnaleziono strony
}

$kategoria = $cms->pobierzKategorie()->pobierz($id);        // Pobierz dane kategorii
if (!$kategoria) {                                          // Jeśli kategoria jest pusta
    include APP_ROOT . '/src/strony/nie-odnaleziono-strony.php';    // Nie odnaleziono strony
}

if (mb_strtolower($czesci[2]) != mb_strtolower($kategoria['seo_nazwa'])) {     // W przypadku błędnej nazwy SEO
    przekieruj('kategoria/' . $id . '/' . $kategoria['seo_nazwa'], [], 301);   // Przekieruj na właściwy URL
}

$dane['nawigacja'] = $cms->pobierzKategorie()->pobierzWszystko();              // Pobierz kategorie do nawigacji
$dane['kategoria']   = $kategoria;                                             // Bieżąca kategoria
$dane['publikacje']   = $cms->pobierzPublikacje()->pobierzWszystko(true, $id); // Pobierz publikacje
$dane['sekcja']    = $kategoria['id'];                                         // Id kategorii do nawigacji

echo $twig->render('kategoria.html', $dane);                                   // Wyrenderuj szablon Twiga