<?php
namespace PhpMysql\Email;                                              // Deklaracja przestrzeni nazw

class Email {

    protected $phpmailer;                                              // Obiekt PHPMailer

    public function __construct($ustaw_email)
    {
        $this->phpmailer = new \PHPMailer\PHPMailer\PHPMailer(true);   // Utwórz obiekt PHPMailer
        $this->phpmailer->isSMTP();                                    // Użyj SMTP
        $this->phpmailer->SMTPAuth   = true;                           // Autoryzacja włączona
        $this->phpmailer->Host       = $ustaw_email['serwer'];         // Adres serwera
        $this->phpmailer->SMTPSecure = $ustaw_email['bezpieczenstwo']; // Rodzaj zaberzpieczeń
        $this->phpmailer->Port       = $ustaw_email['port'];           // Port
        $this->phpmailer->Username   = $ustaw_email['uzytkownik'];     // Nazwa użytkownika
        $this->phpmailer->Password   = $ustaw_email['haslo'];          // Hasło
        $this->phpmailer->SMTPDebug  = $ustaw_email['debug'];          // Metoda debugowania
        $this->phpmailer->CharSet    = 'UTF-8';                        // Kodowanie znaków
        $this->phpmailer->isHTML(true);                                // Wyślij jako HTML
    }

    public function wyslijEmail($od, $do, $temat, $wiadomosc): bool
    {
        $this->phpmailer->setFrom($od);                                // Adres nadawcy
        $this->phpmailer->addAddress($do);                             // Adres odbiorcy
        $this->phpmailer->Subject = $temat;                            // Temat e-maila
        $this->phpmailer->Body    = '<!DOCTYPE html><html lang="pl-PL"><body>'
            . $wiadomosc .'</body></html>';                            // Treść e-maila
        $this->phpmailer->AltBody = strip_tags($wiadomosc);            // Treść w postaci zwykłego tekstu
        $this->phpmailer->send();                                      // Wyślij e-mail
        return true;                                                   // Zwróć true
    }
}