<?php
// UTILITY FUNCTIONS
function przekieruj(string $lokalizacja, array $parametry = [], $kod_odpowiedzi = 302)
{
    $zap = $parametry ? '?' . http_build_query($parametry) : '';  // Utwórz łańcuch zapytania URL
    $lokalizacja = $lokalizacja . $zap;                           // Utwórz nową ścieżkę
    header('Location: ' . DOC_ROOT . $lokalizacja, $kod_odpowiedzi);   // Przekieruj na nową stronę
    exit;                                                          // Zatrzymaj wykonywanie kodu
}

function utworz_nazwepliku(string $nazwapliku, string $sciezka_docelowa): string
{
    $nazwa  = pathinfo($nazwapliku, PATHINFO_FILENAME);          // Get basename
    $rozszerzenie = pathinfo($nazwapliku, PATHINFO_EXTENSION);         // Get extension
    $czystanazwa = preg_replace("/[^A-z0-9]/", "-", $nazwa);     // Clean basename
    $nazwapliku  = $czystanazwa . '.' . $rozszerzenie;                   // Destination
    $i         = 0;                                               // Counter
    while (file_exists($sciezka_docelowa . $nazwapliku)) {                   // If file exists
        $i        = $i + 1;                                       // Update counter
        $nazwapliku = $nazwa . $i . '.' . $rozszerzenie;            // New filename
    }
    return $nazwapliku;                                             // Return filename
}

// ERROR AND EXCEPTION HANDLING FUNCTIONS
// Convert errors to exceptions
function handle_error($error_type, $error_message, $error_file, $error_line)
{
    throw new ErrorException($error_message, 0, $error_type, $error_file, $error_line); // Turn into ErrorException
}

// Handle exceptions - log exception and show error message (if server does not send error page listed in .htaccess)
function handle_exception($e)
{
    error_log($e);                        // Log the error
    http_response_code(500);              // Set the http response code
    echo "<h1>Sorry, a problem occurred</h1>   
          The site's owners have been informed. Please try again later.";
}

// Handle fatal errors
function handle_shutdown()
{
    $error = error_get_last();            // Check for error in script
    if ($error !== null) {                // If there was an error next line throws exception
        $e = new ErrorException($error['message'], 0, $error['type'], $error['file'], $error['line']);
        handle_exception($e);             // Call exception handler
    }
}