<?php
define('APP_ROOT', dirname(__FILE__, 2));                // Katalog główny

require APP_ROOT . '/src/funkcje.php';                   // Funkcje
require APP_ROOT . '/config/config.php';                 // Dane konfiguracyjne
require APP_ROOT . '/vendor/autoload.php';               // Automatyczne ładowanie bibliotek

if (DEV === false) {                                     // Jeśli nie jest to wersja rozwojowa
    set_exception_handler('handle_exception');           // Wskaż procedurę obsługi wyjątków
    set_error_handler('handle_error');                   // Wskaż procedurę obsługi błędów
    register_shutdown_function('handle_shutdown');       // Wskaż procedurę zamykającą
}

$cms = new \PhpMysql\CMS\CMS($dsn, $uzytkownik, $haslo); // Utwórz obiekt CMS
unset($dsn, $uzytkownik, $haslo);                        // Usuń dane dotyczące połączenia z bazą

$opcje_twig['cache'] = APP_ROOT . '/var/cache';          // Ścieżka do pamięci cache Twiga
$opcje_twig['debug'] = DEV;                              // W trybie projektowania włącz debugowanie

$loader = new Twig\Loader\FilesystemLoader(APP_ROOT . '/szablony'); // Obiekt ładujący Twiga
$twig   = new Twig\Environment($loader, $opcje_twig);    // Środowisko Twiga
$twig->addGlobal('doc_root', DOC_ROOT);                  // Katalog główny

if (DEV === true) {                                      // W trybie projektowania
    $twig->addExtension(new \Twig\Extension\DebugExtension()); // Dodaj rozszerzenie DebugExtension 
}