<?php
declare(strict_types = 1);                               // Użyj ścisłej kontroli typów
require 'dolaczane/polaczenie-baza.php';                 // Połączenie z bazą
require 'dolaczane/funkcje.php';                         // Dołącz funkcje

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT); // Sprawdź id
if (!$id) {                                               // Jeśli nie ma prawidłowego id
    include 'nie-odnaleziono-strony.php';                 // Nie odnaleziono strony
}

$sql = "SELECT p.tytul, p.podsumowanie, p.tresc, p.utworzono, p.id_kategorii, p.id_uczestnika, 
               k.nazwa      AS kategoria,
               CONCAT(u.imie, ' ', u.nazwisko) AS autor,
               o.plik AS obraz_plik,
               o.alt  AS obraz_alt
          FROM publikacje   AS p
          JOIN kategorie    AS k  ON p.id_kategorii  = k.id
          JOIN uczestnicy   AS u  ON p.id_uczestnika = u.id
          LEFT JOIN obrazy  AS o  ON p.id_obrazu     = o.id
         WHERE p.id = :id  AND p.opublikowano = 1;";           // Instrukcja SQL

$publikacja = $publikacja = pdo($pdo, $sql, [$id])->fetch();   // Pobierz dane publikacji
if (!$publikacja) {                                            // Jeśli publikacja nie istnieje
    include 'nie-odnaleziono-strony.php';                      // Nie odnaleziono strony
}

$sql = "SELECT id, nazwa FROM kategorie WHERE nawigacja = 1;"; // SQL pobierający kategorie
$nawigacja  = pdo($pdo, $sql)->fetchAll();                     // Pobierz kategorie do nawigacji
$sekcja     = $publikacja['id_kategorii'];                     // Bieżąca kategoria
$tytul      = $publikacja['tytul'];                            // Zawartość znacznika HTML <title>
$opis = $publikacja['podsumowanie'];                           // Opis <meta>
?>
<?php include 'dolaczane/naglowek.php'; ?>
  <main class="article container" id="content">
    <section class="image">
      <img src="wyslane/<?= zastap_html($publikacja['obraz_plik'] ?? 'blank.png') ?>" 
           alt="<?= zastap_html($publikacja['obraz_alt']) ?>">
    </section>
    <section class="text">
      <h1><?= zastap_html($publikacja['tytul']) ?></h1>
      <div class="date"><?= formatuj_date($publikacja['utworzono']) ?></div>
      <div class="content"><?= zastap_html($publikacja['tresc']) ?></div>
      <p class="credit">
        Zamieszczono w <a href="kategoria.php?id=<?= $publikacja['id_kategorii'] ?>"><?= zastap_html($publikacja['kategoria']) ?></a> przez: <a href="uczestnik.php?id=<?= $publikacja['id_uczestnika'] ?>">
          <?= zastap_html($publikacja['autor']) ?></a>
      </p>
    </section>
  </main>
<?php include 'dolaczane/stopka.php'; ?>