<?php
declare(strict_types = 1);                               // Użyj ścisłej kontroli typów
require 'dolaczane/polaczenie-baza.php';                 // Połączenie z bazą
require 'dolaczane/funkcje.php';                         // Dołącz funkcje

$sql = "SELECT p.id, p.tytul, p.podsumowanie, p.id_kategorii, p.id_uczestnika, 
               k.nazwa AS kategoria,
               CONCAT(u.imie, ' ', u.nazwisko) AS autor,
               o.plik      AS obraz_plik,
               o.alt       AS obraz_alt 
          FROM publikacje  AS p
          JOIN kategorie   AS k ON p.id_kategorii  = k.id
          JOIN uczestnicy  AS u ON p.id_uczestnika = u.id
          LEFT JOIN obrazy AS o ON p.id_obrazu     = o.id
         WHERE p.opublikowano = 1
      ORDER BY p.id DESC
         LIMIT 6;";                                    // SQL pobierający najnowsze publikacje
$publikacje = pdo($pdo, $sql)->fetchAll();             // Pobierz podsumowania

$sql = "SELECT id, nazwa FROM kategorie WHERE nawigacja = 1;"; // SQL pobierający kategorie
$nawigacja  = pdo($pdo, $sql)->fetchAll();             // Pobierz kategorie do nawigacji

$sekcja  = '';                                         // Bieżąca kategoria
$tytul   = 'Creative Folk';                            // Zawartość znacznika HTML <title>
$opis    = 'Kreatywne umysły do wynajęcia';            // Opis <meta>
?>
<?php include 'dolaczane/naglowek.php'; ?>
  <main class="container grid" id="content">
    <?php foreach ($publikacje as $publikacja) { ?>
      <article class="summary">
        <a href="publikacja.php?id=<?= $publikacja['id'] ?>">
          <img src="wyslane/<?= zastap_html($publikacja['obraz_plik'] ?? 'blank.png') ?>"
               alt="<?= zastap_html($publikacja['obraz_alt']) ?>">
          <h2><?= zastap_html($publikacja['tytul']) ?></h2>
          <p><?= zastap_html($publikacja['podsumowanie']) ?></p>
        </a>
        <p class="credit">
          Zamieszczono w <a href="kategoria.php?id=<?= $publikacja['id_kategorii'] ?>">
          <?= zastap_html($publikacja['kategoria']) ?></a>
          przez: <a href="uczestnik.php?id=<?= $publikacja['id_uczestnika'] ?>">
          <?= zastap_html($publikacja['autor']) ?></a>
        </p>
      </article>
    <?php } ?>
  </main>
<?php include 'dolaczane/stopka.php'; ?>