<?php
$uzytkownik  = ['imie' => '', 'wiek' => '', 'warunki' => '', ];          // Inicjalizacja
$bledy       = ['imie' => '', 'wiek' => '', 'warunki' => false, ];
$komunikat   = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                              // Jeśli formularz został wysłany
    // Filtry sprawdzające
    $filtry_sprawdzajace['imie']['filter']               = FILTER_VALIDATE_REGEXP;
    $filtry_sprawdzajace['imie']['options']['regexp']    = '/^[A-z]{2,10}$/';
    $filtry_sprawdzajace['wiek']['filter']               = FILTER_VALIDATE_INT;
    $filtry_sprawdzajace['wiek']['options']['min_range'] = 16;
    $filtry_sprawdzajace['wiek']['options']['max_range'] = 65;
    $filtry_sprawdzajace['warunki']                      = FILTER_VALIDATE_BOOLEAN;

    $uzytkownik = filter_input_array(INPUT_POST, $filtry_sprawdzajace);  // Weryfikacja danych

    // Tworzenie komunikatów błędów
    $bledy['imie']  = $uzytkownik['imie']  ? '' : 'Imię musi się składać z 2-10 liter A-z';
    $bledy['wiek']   = $uzytkownik['wiek']   ? '' : 'Musisz mieć 16-65 lat';
    $bledy['warunki'] = $uzytkownik['warunki'] ? '' : 'Konieczna jest zgoda na warunki korzystania z serwisu';
    $niepoprawne = implode($bledy);                                      // Łączenie komunikatów błędów

    if ($niepoprawne) {                                                  // W razie błędów
        $komunikat = 'Prosimy o poprawienie następujących błędów:';      // Nie przetwarzaj
    } else {                                                             // W przeciwnym razie
        $komunikat = 'Dziękujemy za podanie prawidłowych danych.';       // Przetwórz dane
    }

    // Oczyszczanie danych
    $uzytkownik['imie'] = filter_var($uzytkownik['imie'], FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    $uzytkownik['wiek'] = filter_var($uzytkownik['wiek'], FILTER_SANITIZE_NUMBER_INT);
}
?>
<?php include 'dolaczane/naglowek.php'; ?>

<?= $komunikat ?>
<form action="sprawdzanie-formularzy-filtrami.php" method="POST">
  Imię: <input type="text" name="imie" value="<?= $uzytkownik['imie'] ?>">
  <span class="error"><?= $bledy['imie'] ?></span><br>
  Wiek: <input type="text" name="wiek" value="<?= $uzytkownik['wiek'] ?>">
  <span class="error"><?= $bledy['wiek'] ?></span><br>
  <input type="checkbox" name="warunki" value="true"
      <?= $uzytkownik['warunki'] ? 'checked' : '' ?>> Zgadzam się na warunki korzystania z serwisu
  <span class="error"><?= $bledy['warunki'] ?></span><br>
  <input type="submit" value="Zapisz">
</form>

<?php include 'dolaczane/stopka.php'; ?>