<?php
namespace PhpMysql\CMS;                                   // Deklaracja przestrzeni nazw

class Polubienie
{                                                         // Definicja klasy Polubienie
    protected $db;                                        // Zawiera odwołanie do obiektu Baza

    public function __construct(Baza $db)                 // Uruchamia się przy tworzeniu obiektu tej klasy
    {
        $this->db = $db;                                  // Przechowaj obiekt Baza we właściwości $db
    }

    public function pobierz(array $polubienie): bool
    {
        $sql = "SELECT COUNT(*)
                  FROM polubienia
                 WHERE id_publikacji = :id 
                   AND id_uczestnika = :id_uczestnika;";                 // SQL
        return $this->db->wykonajSQL($sql, $polubienie)->fetchColumn();  // Wykonaj i zwróć 1 lub 0
    }

    public function utworz(array $polubienie): bool
    {
        $sql = "INSERT INTO polubienia (id_publikacji, id_uczestnika) 
                VALUES (:id_publikacji, :id_uczestnika);";               // SQL
        $this->db->wykonajSQL($sql, $polubienie);                        // Wykonaj SQL
        return true;                                                     // Zwróć true
    }

    public function usun(array $polubienie): bool
    {
        $sql = "DELETE FROM polubienia
                 WHERE id_publikacji = :id_publikacji 
                   AND id_uczestnika = :id_uczestnika;";                 // SQL
        $this->db->wykonajSQL($sql, $polubienie);                        // Wykonaj SQL
        return true;                                                     // Zwróć true
    }

}