<?php
declare(strict_types = 1);                                   // Użyj ścisłej kontroli typów
include '../src/bootstrap.php';                              // Plik konfiguracyjny

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);    // Sprawdź id
if (!$id) {                                                  // Jeśli id nie jest prawidłowa
    include APP_ROOT . '/public/nie-odnaleziono-strony.php'; // Strony nie odnaleziono
}

$kategoria = $cms->pobierzKategorie()->pobierz($id);         // Pobierz dane kategorii
if (!$kategoria) {                                           // Jeśli kategoria jest pusta
    include APP_ROOT . '/public/nie-odnaleziono-strony.php'; // Strony nie odnaleziono
}

$publikacje    = $cms->pobierzPublikacje()->pobierzWszystko(true, $id);     // Pobierz publikacje

$nawigacja = $cms->pobierzKategorie()->pobierzWszystko();    // Pobierz kategorie do nawigacji
$sekcja    = $kategoria['id'];                               // Bieżąca kategoria
$tytul     = $kategoria['nazwa'];                            // Zawartość znacznika HTML <title>
$opis      = $kategoria['opis'];                             // Zawartość znacznika <meta>
?>
<?php include APP_ROOT . '/public/dolaczane/naglowek.php' ?>
  <main class="container" id="content">
    <section class="header">
      <h1><?= zastap_html($kategoria['nazwa']) ?></h1>
      <p><?= zastap_html($kategoria['opis']) ?></p>
    </section>
    <section class="grid">
    <?php foreach ($publikacje as $publikacja) { ?>
      <article class="summary">
        <a href="publikacja.php?id=<?= $publikacja['id'] ?>">
          <img src="wyslane/<?= zastap_html($publikacja['obraz_plik'] ?? 'blank.png') ?>"
               alt="<?= zastap_html($publikacja['obraz_alt']) ?>">
          <h2><?= zastap_html($publikacja['tytul']) ?></h2>
          <p><?= zastap_html($publikacja['podsumowanie']) ?></p>
        </a>
        <p class="credit">
          Zamieszczono w <a href="kategoria.php?id=<?= $publikacja['id_kategorii'] ?>">
          <?= zastap_html($publikacja['kategoria']) ?></a>
          przez: <a href="uczestnik.php?id=<?= $publikacja['id_uczestnika'] ?>">
          <?= zastap_html($publikacja['autor']) ?></a>
        </p>
      </article>
    <?php } ?>
    </section>
  </main>
<?php include APP_ROOT . '/public/dolaczane/stopka.php' ?>