<?php
include 'klasy/ObslugaObrazu.php';                               // Dołącz klasę
$komunikat = '';                                                 // Zainicjalizuj zmienne
$miniatura   = '';
$email   = ''; 

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                      // Jeśli formularz został przesłany
    $email = $_POST['email'] ?? '';                              // Pobierz e-mail użytkownika
    if ($_FILES['obraz']['error'] == 0) {                        // Jeśli nie było błędów
        $plik = $_FILES['obraz']['name'];                        // Pobierz nazwę pliku
        $tymcz = $_FILES['obraz']['tmp_name'];                   // Pobierz lokalizację tymczasową

        try {                                                    // Spróbuj przeskalować obraz
            $obraz = new ObslugaObrazu($tymcz, $plik);           // Utwórz obiekt
            $miniatura = $obraz->przeskalujObraz(300, 300, 'wyslane/');  // Przeskaluj obraz
            $komunikat = '<img src="' . $miniatura . '">';       // Uwzgldnij obraz w zmiennej $komunikat
        } catch (ObslugaObrazuWyjatek $e) {                      // W razie wyjątku klasy ObslugaObrazuWyjatek
            $komunikat = $e->getMessage();                       // Pobierz komunikat błędu
        } catch (Throwable $e) {                                 // W innych przypadkach
            $komunikat = 'Nie udało się zapisać obrazu';         // Wyświetl ogólny komunikat błędu
            error_log($e);                                       // Zapisz błąd do logu
        }
    }  
    // W tym miejscu strona mogłaby zapisać e-mail użytkownika
    $komunikat = 'Dziękujemy za rejestrację<br>' . $komunikat;   // Dodaj do komunikatu potwierdzenie rejestracji
}
?>
<?php include 'dolaczane/naglowek.php' ?> 
<h1>Dołącz do nas</h1>
<?= $komunikat ?>
<?php if (!$komunikat) { ?>
  <form method="POST" action="wyrzucanie-wyjatkow.php" enctype="multipart/form-data">
    E-mail:   <input type="text" name="email" value="<?= htmlspecialchars($email) ?>"><br>
    Zdjęcie: <input type="file" name="obraz" id="obraz"/><br>
    <input type="submit" value="Zapisz">
  </form>
<?php } ?>
<?php include 'dolaczane/stopka.php' ?> 