<?php
$przeniesiono      = false;                                        // Inicjalizacja
$komunikat         =  '';                                          // Inicjalizacja
$blad              = '';                                           // Inicjalizacja
$sciezka_docelowa  = 'wyslane/';                                   // Docelowa ścieżka
$max_rozmiar       = 5242880;                                      // Maksymalny rozmiar pliku
$dozwolone_typy    = ['image/jpeg', 'image/png', 'image/gif',];    // Dozwolone typy plików
$dozwolone_roz     = ['jpeg', 'jpg', 'png', 'gif',];               // Dozwolone rozszerzenia

function utworz_nazwepliku($nazwapliku, $sciezka_docelowa)         // Funkcja tworząca nazwę pliku
{
    $nazwa   = pathinfo($nazwapliku, PATHINFO_FILENAME);           // Pobierz nazwę
    $rozszerzenie  = pathinfo($nazwapliku, PATHINFO_EXTENSION);    // Pobierz rozszerzenie
    $nazwa   = preg_replace('/[^A-z0-9]/', '-', $nazwa);           // Oczyść nazwę
	$nazwapliku   = $nazwa . '.' . $rozszerzenie;                  // Dodaj rozszerzenie do oczyszczonej nazwy pliku
    $i          = 0;                                               // Licznik
    while (file_exists($sciezka_docelowa . $nazwapliku)) {         // Jeśli plik istnieje...
        $i        = $i + 1;                                        // Zaktualizuj licznik
        $nazwapliku = $nazwa . $i . '.' . $rozszerzenie;           // Nowa ścieżka
    }
    return $nazwapliku;                                            // Zwróć ścieżkę
}

function przeskaluj_obraz_gd($sciezka_oryg, $sciezka_nowa, $maks_szer, $maks_wys)
{
    $dane_obrazu  = getimagesize($sciezka_oryg);                   // Pobierz dane o obrazie
    $oryg_szer  = $dane_obrazu[0];                                 // Szerokość obrazu
    $oryg_wys = $dane_obrazu[1];                                   // Wysokość obrazu
    $typ_obrazu  = $dane_obrazu['mime'];                           // Typ obrazu
    $nowa_szer   = $maks_szer;                                     // Nowa szerokość maksymalna
    $nowa_wys  = $maks_wys;                                        // Nowa wysokość maksymalna
    $oryg_prop  = $oryg_szer / $oryg_wys;                          // Proporcje oryginalnego obrazu

    // Oblicz nowy rozmiar
    if ($oryg_szer > $oryg_wys) {                                  // Jeśli poziomy
        $nowa_wys = $nowa_szer / $oryg_prop;                       // Ustal wysokość na podstawie proporcji
    } else {                                                       // W przeciwnym razie
        $nowa_szer  = $nowa_wys * $oryg_prop;                      // Ustal szerokość na podstawie proporcji
    }
    
    switch($typ_obrazu) {                                          // Sprawdź format
        case 'image/gif' :                                         // Jeśli GIF 
            $oryg = imagecreatefromgif($sciezka_oryg);             // Ta funkcja otwiera obraz
            break;                                                 // Koniec instrukcji switch
        case 'image/jpeg' :                                        // Jeśli JPEG
            $oryg = imagecreatefromjpeg($sciezka_oryg);            // Ta funkcja otwiera obraz
            break;                                                 // Koniec instrukcji switch
        case 'image/png' :                                         // Jeśli PNG
            $oryg = imagecreatefrompng($sciezka_oryg);             // Ta funkcja otwiera obraz
            break;                                                 // Koniec instrukcji switch
    }

    $nowy = imagecreatetruecolor($nowa_szer, $nowa_wys);           // Utwórz pusty obraz

    imagecopyresampled($nowy, $oryg, 0, 0, 0, 0, $nowa_szer, $nowa_wys,
        $oryg_szer, $oryg_wys);                                    // Skopiuj oryginał do nowego obrazu

    // Zapisz obraz - folder docelowy musi istnieć i mieć ustawione odpowiednie prawa dostępu
    switch($typ_obrazu) {
        case 'image/gif' : $rezultat = imagegif($nowy, $sciezka_nowa);  break;
        case 'image/jpeg': $rezultat = imagejpeg($nowy, $sciezka_nowa); break;
        case 'image/png' : $rezultat = imagepng($nowy, $sciezka_nowa);  break;
    }
    return $rezultat;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                        // Jeśli formularz został przesłany
    $blad = ($_FILES['obraz']['error'] === 1) ? 'za duży ' : '';   // Sprawdź obraz pod kątem rozmiaru

    if ($_FILES['obraz']['error'] == 0) {                          // Jeśli nie ma błędów
        $blad  .= ($_FILES['obraz']['size'] <= $max_rozmiar) ? '' : 'za duży '; // Sprawdź rozmiar
        // Sprawdź typ MIME w tablicy $dozwolone_typy
        $typ   = mime_content_type($_FILES['obraz']['tmp_name']);        
        $blad .= in_array($typ, $dozwolone_typy) ? '' : 'nieobsługiwany typ ';
        // Sprawdź rozszerzenie w tablicy $dozwolone_roz
        $roz    = strtolower(pathinfo($_FILES['obraz']['name'], PATHINFO_EXTENSION));
        $blad .= in_array($roz, $dozwolone_roz) ? '' : 'nieobsługiwane rozszerzenie ';

        // Jeśli nie ma błędów, utwórz nową ścieżkę i spróbuj przenieść plik
		
        if (!$blad) {
          $nazwapliku    = utworz_nazwepliku($_FILES['obraz']['name'], $sciezka_docelowa);
          $docelowy = $sciezka_docelowa . $nazwapliku;
          $przeniesiono       = move_uploaded_file($_FILES['obraz']['tmp_name'], $docelowy);
          $sciezkamin   = $sciezka_docelowa . 'min_' . $nazwapliku;
          $przeskalowano     = przeskaluj_obraz_gd($docelowy, $sciezkamin, 200, 200);
        }
    }
    if ($przeniesiono === true and $przeskalowano === true) {            // Jeśli został przeniesiony
        $przeniesiono = '<img src="' . $sciezkamin . '">';               // Wyświetl obraz
    } else {                                                             // W przeciwnym razie
        $przeniesiono = '<b>Nie udało się przesłać pliku</b> ' . $blad;  // Wyświetl błędy
    }
}
?>
<?php include 'dolaczane/naglowek.php' ?>
<?= $przeniesiono ?>
  <form method="POST" action="skalowanie-gd.php" enctype="multipart/form-data">
    <label for="obraz"><b>Prześlij plik:</b></label>
    <input type="file" name="obraz" accept="image/*" id="obraz"><br>
    <input type="submit" value="Wyślij">
  </form>
<?php include 'dolaczane/stopka.php' ?>