<?php
namespace PhpMysql\CMS;                                   // Deklaracja przestrzeni nazw

class CMS
{
    protected $db          = null;                   // Przechowuje referencję do obiektu Baza
    protected $publikacja  = null;                   // Przechowuje referencję do obiektu Publikacja
    protected $kategoria   = null;                   // Przechowuje referencję do obiektu Kategoria
    protected $uczestnik   = null;                   // Przechowuje referencję do obiektu Uczestnik
    protected $sesja       = null;                   // Przechowuje referencję do obiektu Sesja
    protected $token       = null;                   // Przechowuje referencję do obiektu Token
    protected $polubienie  = null;                   // Przechowuje referencję do obiektu Polubienie
    protected $komentarz   = null;                   // Przechowuje referencję do obiektu Komentarz

    public function __construct($dsn, $uzytkownik, $haslo)
    {
        $this->db = new Baza($dsn, $uzytkownik, $haslo); // Tworzy obiekt Baza
    }

    public function pobierzPublikacje()
    {
        if ($this->publikacja === null) {                    // Jeśli właściwość $publikacja jest pusta
            $this->publikacja = new Publikacja($this->db);   // Utwórz obiekt Publikacja
        }
        return $this->publikacja;                            // Zwróć obiekt Publikacja
    }

    public function pobierzKategorie()
    {
        if ($this->kategoria === null) {                     // Jeśli właściwość $kategoria jest pusta
            $this->kategoria = new Kategoria($this->db);     // Utwórz obiekt Kategoria
        }
        return $this->kategoria;                             // Zwróć obiekt Kategoria
    }

    public function pobierzUczestnika()
    {
        if ($this->uczestnik === null) {                     // Jeśli właściwość $uczestnik jest pusta
            $this->uczestnik = new Uczestnik($this->db);     // Utwórz obiekt Uczestnik
        }
        return $this->uczestnik;                             // Zwróć obiekt Uczestnik
    }

    public function pobierzSesje()
    {
        if ($this->sesja === null) {                         // Jeśli właściwość $sesja jest pusta
            $this->sesja = new Sesja($this->db);             // Utwórz obiekt Sesja
        }
        return $this->sesja;                                 // Zwróć obiekt Sesja
    }

    public function pobierzToken()
    {
        if ($this->token === null) {                         // Jeśli właściwość $token jest pusta
            $this->token = new Token($this->db);             // Utwórz obiekt Token
        }
        return $this->token;                                 // Zwróć obiekt Token
    }

    public function pobierzPolubienie()
    {
        if ($this->polubienie === null) {                    // Jeśli właściwość $polubienie jest pusta
            $this->polubienie = new Polubienie($this->db);   // Utwórz obiekt Polubienie
        }
        return $this->polubienie;                            // Zwróć obiekt Polubienie
    }

    public function pobierzKomentarz()
    {
        if ($this->komentarz === null) {                     // Jeśli właściwość $komentarz jest pusta
            $this->komentarz = new Komentarz($this->db);     // Utwórz obiekt Komentarz
        }
        return $this->komentarz;                             // Zwróć obiekt Komentarz
    }
}