<?php
include '../src/bootstrap.php';                                // Plik konfiguracyjny

$sciezka  = mb_strtolower($_SERVER['REQUEST_URI']);            // Zamień litery ścieżki na małe
$sciezka  = substr($sciezka, strlen(DOC_ROOT));                // Usuń ścieżkę do DOC_ROOT
$czesci = explode('/', $sciezka);                              // Podziel w miejscach / i zapisz w tablicy

if ($czesci[0] != 'admin') {                                   // Jeśli strona administracyjna
    $strona = $czesci[0] ?: 'index';                           // Nazwa strony (lub index)
    $id   = $czesci[1] ?? null;                                // Pobierz ID (lub użyj wartości null)
} else {                                                       // Jeśli nie chodzi o stronę administracyjną
    $strona = 'admin/' . ($czesci[1] ?? '');                   // Nazwa strony
    $id   = $czesci[2] ?? null;                                // Pobierz ID
}
$id = filter_var($id, FILTER_VALIDATE_INT);                    // Sprawdź ID

$strona_php = APP_ROOT . '/src/strony/' . $strona . '.php';    // Ścieżka do strony PHP

if (!file_exists($strona_php)) {                               // Jeśli strony nie ma w tablicy
    $strona_php = APP_ROOT . '/src/strony/nie-odnaleziono-strony.php';  // Dołącz plik "nie odnaleziono strony" 
}
include $strona_php;                                           // Dołącz plik PHP