<?php
declare(strict_types = 1);                                  // Użyj ścisłej kontroli typów
require '../dolaczane/polaczenie-baza.php';                 // Połączenie z bazą
require '../dolaczane/funkcje.php';                         // Dołącz funkcje

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);   // Pobierz i sprawdź id
$kategoria = '';                                            // Zainicjalizuj tablicę kategorii

if (!$id) {                                                 // Jeśli nie ma prawidłowego id
    przekieruj('kategorie.php', ['niepowodzenie' => 'Nie odnaleziono kategorii']); // Przekieruj z błędem
}

$sql = "SELECT nazwa FROM kategorie WHERE id = :id;";       // Zapytanie SQL o nazwę kategorii
$kategoria = pdo($pdo, $sql, [$id])->fetchColumn();         // Pobierz nazwę kategorii
if (!$kategoria) {                                          // Jeśli nie ma takiej kategorii
    przekieruj('kategorie.php', ['niepowodzenie' => 'Nie odnaleziono kategorii']); // Przekieruj z błędem
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                 // Jeśli formularz został przesłany
    try {                                                   // Spróbuj usunąć dane
        $sql = "DELETE FROM kategorie WHERE id = :id;";     // Instrukcja SQL
        pdo($pdo, $sql, [$id]);                             // Wykonanie instrukcji
        przekieruj('kategorie.php', ['sukces' => 'Kategoria została usunięta']); // Przekieruj
    } catch (PDOException $e) {                             // Przechwytywanie wyjątków
        if ($e->errorInfo[1] === 1451) {                    // W razie naruszenia zasady integralności
            przekieruj('kategorie.php', ['niepowodzenie' => 'Kategoria zawiera publikacje, które 
			powinny zostać przeniesione lub skasowane przed jej usunięciem']); // Przekieruj
        } else {                                            // W przeciwnym razie
            throw $e;                                       // Ponownie wyrzuć wyjątek
        }
    }
}
?>
<?php include '../dolaczane/admin-naglowek.php'; ?>
  <main class="container admin" id="content">
     <h1>Usuń kategorię</h1>
	 <form action="usun-kategorie.php?id=<?= $id ?>" method="POST" class="narrow">
      <p>Kliknij <em>Potwierdź</em>, aby usunąć kategorię: <em><?= zastap_html($kategoria) ?></em></p>
      <input type="submit" name="skasuj" value="Potwierdź" class="btn btn-primary">
      <a href="kategorie.php" class="btn btn-danger">Anuluj</a>
    </form>
  </main>
<?php include '../dolaczane/admin-stopka.php'; ?>