<?php
require '../cms/dolaczane/polaczenie-baza.php';               // Utwórz obiekt PDO
require '../cms/dolaczane/funkcje.php';                       // Funkcje
$sql        = "SELECT id, imie, nazwisko, dolaczyl, zdjecie FROM uczestnicy;"; // SQL
$instrukcja = $pdo->query($sql);                              // Uruchom zapytanie
$uczestnicy = $instrukcja->fetchAll();                        // Pobierz dane
?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <title>Formatowanie danych na stronach HTML</title>
    <link rel="stylesheet" type="text/css" href="css/styles.css" />
  </head>
  <body>
    <div class="member-summary-grid">
      <?php foreach ($uczestnicy as $uczestnik) { ?>
        <div class="member-summary">
               <img src="../cms/wyslane/<?= zastap_html($uczestnik['zdjecie'] ?? 'pusta-fotka.png') ?>"
               alt="<?= zastap_html($uczestnik['imie']) ?>" class="profile">
          <h2><?= zastap_html($uczestnik['imie']) . ' ' . zastap_html($uczestnik['nazwisko']) ?></h2>
          <p>Uczestniczy od:<br><?= formatuj_date($uczestnik['dolaczyl']) ?></p>
        </div>
      <?php } ?>
    </div>
  </body>
</html>