<?php
declare(strict_types = 1);

class Konto {
    public    array  $numer;
    public    string $typ;
    protected float  $stan;

    public function __construct(array $numer, string $typ, float $stan = 0.00)
    {
        $this->numer  = $numer;
        $this->typ    = $typ;
        $this->stan = $stan;
    }

    public function wplac(float $kwota): float
    {
        $this->stan += $kwota;
        return $this->stan;
    }

    public function wyplac(float $kwota): float
    {
        $this->stan -= $kwota;
        return $this->stan;
    }

    public function sprawdzStan(): float
    {
        return $this->stan;
    }
}

// Tworzenie tablicy do umieszczenia we właściwości
$numery = ['numer_konta' => 12345678,
           'numer_rozliczeniowy' => 987654321,];

// Tworzenie instancji klasy i ustawianie jej właściwości
$konto = new Konto($numery, 'Oszczędnościowe', 10.00);
?>
<?php include 'dolaczane/naglowek.php'; ?>
<h2>Konto <?= $konto->typ ?></h2>
Nr konta <?= $konto->numer['numer_konta'] ?><br>
Nr rozliczeniowy <?= $konto->numer['numer_rozliczeniowy'] ?>
<?php include 'dolaczane/stopka.php'; ?>