<?php
$usunieto = null;                                             // Czy publikacja została usunięta?
czyAdmin($sesja->rola);                                       // Sprawdź status administratora

if (!$id) {                                                   // Jeśli nie ma id
    przekieruj('admin/publikacje/', ['niepowodzenie' => 'Nie odnaleziono publikacji']); // Przekieruj z błędem
}

$publikacja = $cms->pobierzPublikacje()->pobierz($id, false); // Pobierz publikację
if (!$publikacja) {                                           // Jeśli nie ma publikacji
    przekieruj('admin/publikacje/', ['niepowodzenie' => 'Nie odnaleziono publikacji']); // Przekieruj z błędem
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                   // If form was submitted
    if (isset($publikacja['id_obrazu'])) {                    // Jeśli istnieje obraz
        $sciezka = APP_ROOT . '/public/wyslane/' . $publikacja['obraz_plik']; // Określ ścieżkę do pliku z obrazem
        $cms->pobierzPublikacje()->usunObraz($publikacja['id_obrazu'], $sciezka, $id); // Usuń obraz
    }
    $usunieto = $cms->pobierzPublikacje()->usun($id);         // Usuń publikację
    if ($usunieto === true) {                                 // Jeśli usunięta
        przekieruj('admin/publikacje/', ['sukces' => 'Publikacja została usunięta']); // Przekieruj
    } else {                                                  // Otherwise
        throw new Exception('Nie udało się usunąć publikacji');  // Wyrzuć wyjątek
    }
}

$dane['publikacja'] = $publikacja;                            // Publikacja

echo $twig->render('admin/usun-publikacje.html', $dane);      // Wyrenderuj szablon