<?php
namespace PhpMysql\CMS;                                  // Deklaracja przestrzeni nazw

class Kategoria
{
    protected $db;                                       // Zawiera referencję do obiektu Baza

    public function __construct(Baza $db)
    {
        $this->db = $db;                                 // Tworzy referencję do obiektu Baza
    }

    // Pobierz jedną kategorię
    public function pobierz(int $id)
    {
        $sql = "SELECT id, nazwa, opis, nawigacja, seo_nazwa 
                  FROM kategorie 
                 WHERE id = :id;";                       // SQL pobierający jedną kategorię
        return $this->db->wykonajSQL($sql, [$id])->fetch();  // Zwróć dane kategorii
    }

    // Pobierz wszystkie kategorie
    public function pobierzWszystko(): array
    {
        $sql = "SELECT id, nazwa, nawigacja 
                  FROM kategorie;";                       // SQL pobierający wszystkie kategorie
        return $this->db->wykonajSQL($sql)->fetchAll();      // Zwróć wszystkie kategorie
    }

    // METODY ADMINISTRACYJNE
    // Pobierz liczbę kategorii
    public function policz(): int
    {
        $sql = "SELECT COUNT(id) FROM kategorie;";        // SQL zliczający kategorie
        return $this->db->wykonajSQL($sql)->fetchColumn();   // Zwróć liczbę kategorii
    }

    // Utwórz nową kategorię
    public function utworz(array $kategoria): bool
    {
        try {                                             // Spróbuj utworzyć kategorię
            $sql = "INSERT INTO kategorie (nazwa, opis, nawigacja, seo_nazwa) 
                    VALUES (:nazwa, :opis, :nawigacja, :seo_nazwa);"; // SQL dodający nową kategorię
            $this->db->wykonajSQL($sql, $kategoria);      // Dodaj nową kategorię
            return true;                                  // Jeśli się udało, zwróć true
        } catch (\PDOException $e) {                      // W razie wyrzucenia wyjątku
            if ($e->errorInfo[1] === 1062) {              // Jeśli błąd wskazuje na powtórzenie nazwy
                return false;                             // Zwróć false, aby poinformować o powtórzeniu nazwy
            } else {                                      // W przypadku innego błędu
                throw $e;                                 // Ponownie wyrzuć wyjątek
            }
        }
    }

    // Aktualizacja kategorii
    public function aktualizuj(array $kategoria): bool
    {
        try {                                            // Spróbuj zaktualizować kategorię
            $sql = "UPDATE kategorie 
                       SET nazwa = :nazwa, opis = :opis, nawigacja = :nawigacja, seo_nazwa = :seo_nazwa 
                     WHERE id = :id;";                   // SQL aktualizujący kategorię
            $this->db->wykonajSQL($sql, $kategoria);     // Zaktualizuj kategorię
            return true;                                 // Jeśli się udało, zwróć true
        } catch (\PDOException $e) {                     // W razie wyrzucenia wyjątku
            if ($e->errorInfo[1] === 1062) {             // Jeśli błąd wskazuje na powtórzenie nazwy
                return false;                            // Zwróć false, aby poinformować o powtórzeniu nazwy
            } else {                                     // W przypadku innego błędu
                throw $e;                                // Ponownie wyrzuć wyjątek
            }
        }
    }

    // Usuwanie kategorii
    public function usun(int $id): bool
    {
        try {                                            // Spróbuj usunąć kategorię
            $sql = "DELETE FROM kategorie 
                    WHERE id = :id;";                    // SQL usuwający kategorię
            $this->db->wykonajSQL($sql, [$id]);          // Usuń kategorię
            return true;                                 // Jeśli się udało, zwróć true
        } catch (\PDOException $e) {                     // W razie wyrzucenia wyjątku
            if ($e->errorInfo[1] === 1451) {             // Jeśli błąd wskazuje na naruszenie integralności
                return false;                            // Zwróć false
            } else {                                     // W przypadku innego błędu
                throw $e;                                // Ponownie wyrzuć wyjątek
            }
        }
    }

}