<?php
namespace PhpMysql\Weryfikacja;                              // Deklaracja przestrzeni nazw

class Weryfikacja
{
    public static function czyLiczba($liczba, $min = 0, $max = 100): bool
    {
        return ($liczba >= $min and $liczba <= $max);
    }

    public static function czyTekst(string $tekst, int $min = 0, int $max = 1000): bool
    {
        $dlugosc = mb_strlen($tekst);
        return ($dlugosc >= $min and $dlugosc <= $max);
    }

    public static function czyHaslo($haslo)
    {
        if ( mb_strlen($haslo) >= 8                      // Co najmniej 8 znaków
            and preg_match('/[A-Z]/', $haslo)            // Ma zawierać dużą literę A-Z
            and preg_match('/[a-z]/', $haslo)            // Ma zawierać małą literę  a-z
            and preg_match('/[0-9]/', $haslo)            // Ma zawierać 0-9
        ) {
            return true;                                 // Wszystkie testy zaliczone
        }
        return false;                                    // Nieprawidłowe hasło
    }
	
    public static function czyEmail($email): bool
    {
        return (filter_var($email, FILTER_VALIDATE_EMAIL)) ? true : false;
    }	

    public static function czyIdUczestnika($id_uczestnika, array $lista_uczestnikow): bool
    {
        foreach ($lista_uczestnikow as $uczestnik) {
            if ($uczestnik['id'] == $id_uczestnika) {
                return true;
            }
        }
        return false;
    }

    public static function czyIdKategorii($id_kategorii, array $lista_kategorii): bool
    {
        foreach ($lista_kategorii as $kategoria) {
            if ($kategoria['id'] == $id_kategorii) {
                return true;
            }
        }
        return false;
    }
}