<?php
class CMS
{
    protected $db         = null;                   // Przechowuje referencję do obiektu Baza
    protected $publikacja = null;                   // Przechowuje referencję do obiektu Publikacja
    protected $kategoria  = null;                   // Przechowuje referencję do obiektu Kategoria
    protected $uczestnik  = null;                   // Przechowuje referencję do obiektu Uczestnik

    public function __construct($dsn, $uzytkownik, $haslo)
    {
        $this->db = new Baza($dsn, $uzytkownik, $haslo);     // Tworzy obiekt Baza
    }

    public function pobierzPublikacje()
    {
        if ($this->publikacja === null) {                    // Jeśli właściwość $publikacja jest pusta
            $this->publikacja = new Publikacja($this->db);   // Utwórz obiekt Publikacja
        }
        return $this->publikacja;                            // Zwróć obiekt Publikacja
    }

    public function pobierzKategorie()
    {
        if ($this->kategoria === null) {                     // Jeśli właściwość $kategoria jest pusta
            $this->kategoria = new Kategoria($this->db);     // Utwórz obiekt Kategoria
        }
        return $this->kategoria;                             // Zwróć obiekt Kategoria
    }

    public function pobierzUczestnika()
    {
        if ($this->uczestnik === null) {                     // Jeśli właściwość $uczestnik jest pusta
            $this->uczestnik = new Uczestnik($this->db);     // Utwórz obiekt Uczestnik
        }
        return $this->uczestnik;                             // Zwróć obiekt Uczestnik
    }
}