<?php
class Baza extends PDO
{
    public function __construct(string $dsn, string $uzytkownik, string $haslo, array $opcje = [])
    {
        $opcje_domyslne[PDO::ATTR_DEFAULT_FETCH_MODE] = PDO::FETCH_ASSOC; // Zwróć dane w postaci tablicy
        $opcje_domyslne[PDO::ATTR_EMULATE_PREPARES]   = false;            // Wyłącz emulację przygotowania instrukcji
        $opcje_domyslne[PDO::ATTR_ERRMODE]            = PDO::ERRMODE_EXCEPTION; // Ustawienia błędów
        $opcje = array_replace($opcje_domyslne, $opcje);      // Zastąp opcje domyślne, jeśli zostały podane
        parent::__construct($dsn, $uzytkownik, $haslo, $opcje); // Utwórz obiekt PDO
    }

    public function wykonajSQL(string $sql, $argumenty = null)
    {
        if (!$argumenty) {                                // Jeśli nie podano argumentów
            return $this->query($sql);                    // Wykonaj SQL, zwróć obiekt PDOStatement
        }
        $instrukcja = $this->prepare($sql);               // Jeśli kod nadal działa, przygotuj instrukcję
        $instrukcja->execute($argumenty);                 // Wykonaj instrukcję SQL z argumentami
        return $instrukcja;                               // Zwróć obiekt PDOStatement
    }
}