<?php
// CZĘŚĆ A: Przygotowanie
declare(strict_types=1);                                 // Użyj ścisłej kontroli typów
include '../../src/bootstrap.php';                       // Dołącz plik konfiguracyjny

// Inicjalizacja zmiennych potrzebnych w kodzie PHP
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);// Pobierz i sprawdź id
$zapisano = null;                                        // Czy kategoria została zapisana

// Inicjalizacja zmiennych potrzebnych na stronie HTML
$kategoria = [
    'id'          => $id,
    'nazwa'       => '',
    'opis'        => '',
    'nawigacja'   => false,
];                                                       // Inicjalizacja tablicy kategorii
$bledy = [
    'ostrzezenie' => '',
    'nazwa'       => '',
    'opis'        => '',
];                                                       // Inicjalizacja tablicy błędów

if ($id) {                                               // Jeśli nie podano id
    $kategoria = $cms->pobierzKategorie()->pobierz($id); // Pobierz dane kategoriii
    if (!$kategoria) {                                   // Jeśli nie ma danych kategorii
        przekieruj('admin/kategorie.php', ['niepowodzenie' => 'Nie odnaleziono kategorii']); // Przekieruj z błędem
    }
}

// CZĘŚĆ B: Pobierz i zweryfikuj dane z formularza
if ($_SERVER['REQUEST_METHOD'] == 'POST') {                 // Jeśli przesłano formularz
    $kategoria['nazwa']        = $_POST['nazwa'];           // Pobierz nazwę
    $kategoria['opis']         = $_POST['opis'];            // Pobierz opis
    $kategoria['nawigacja']    = (isset($_POST['nawigacja']) and ($_POST['nawigacja'] == 1)) ? 1 : 0; // Pobierz nawigację
    // Sprawdź poprawność wszystkich danych i utwórz komunikaty w razie błędów 
    $bledy['nazwa']          = (Weryfikacja::czyTekst($kategoria['nazwa'], 1, 24))
        ? '' : 'Nazwa powinna składać się z 1-24 znaków.';  // Sprawdź nazwę
    $bledy['opis']   = (Weryfikacja::czyTekst($kategoria['opis'], 1, 254))
        ? '' : 'Opis powinien składać się z 1-254 znaków.'; // Sprawdź opis

    $nieprawidlowe = implode($bledy);                       // Połącz komunikaty błędów

// CZĘŚĆ C: Po skontrolowaniu poprawności danych zaktualizuj bazę
    if ($nieprawidlowe) {                                   // Jeśli dane są nieprawidłowe
        $bledy['ostrzezenie'] = 'Proszę poprawić błędy';    // Komunikat błędu
    } else {                                                // W przeciwnym razie utwórz lub zaktualizuj
        $argumenty = $kategoria;                            // Definicja tablicy $argumenty dla SQL
        if ($id) {                                          // Jeśli jest id
            $zapisano = $cms->pobierzKategorie()->aktualizuj($argumenty); // spróbuj zaktualizować kategorię
        } else {                                            // Jeśli nie ma id
            unset($argumenty['id']);                        // Usuń id z tablicy
            $zapisano = $cms->pobierzKategorie()->utworz($argumenty); // Spróbuj utworzyć kategorię
        }
        if ($zapisano === true) {                           // Jeśli się udało
            przekieruj('admin/kategorie.php', ['sukces' => 'Kategoria zapisana']); // Przekieruj
        }
        if ($zapisano === false) {                          // Jeśli nazwa kategorii  istnieje
            $bledy['ostrzezenie'] = 'Nazwa kategorii już istnieje'; // Zapisz komunikat błędu
        }
    }
}
?>
<?php include APP_ROOT . '/public/dolaczane/admin-naglowek.php'; ?>
  <main class="container admin" id="content">
    <form action="kategoria.php?id=<?= $id ?>" method="post" class="narrow">
      <h1>Edytuj kategorię</h1>
      <?php if ($bledy['ostrzezenie']) { ?>
        <div class="alert alert-danger"><?= $bledy['ostrzezenie'] ?></div>
      <?php } ?>

      <div class="form-group">
        <label for="nazwa">Nazwa: </label>
        <input type="text" name="nazwa" id="nazwa"
               value="<?= zastap_html($kategoria['nazwa']) ?>" class="form-control">
        <span class="errors"><?= $bledy['nazwa'] ?></span>
      </div>

      <div class="form-group">
        <label for="opis">Opis: </label>
        <textarea name="opis" id="opis"
                  class="form-control"><?= zastap_html($kategoria['opis']) ?></textarea>
        <span class="errors"><?= $bledy['opis'] ?></span>
      </div>

      <div class="form-check">
        <input type="checkbox" name="nawigacja" id="nawigacja"
               value="1" class="form-check-input"
          <?= ($kategoria['nawigacja'] === 1) ? 'checked' : '' ?>>
        <label class="form-check-label" for="nawigacja">Nawigacja</label>
      </div>

      <input type="submit" value="Zapisz" class="btn btn-primary btn-save">
    </form>
  </main>
<?php include APP_ROOT . '/public/dolaczane/admin-stopka.php'; ?>