--
-- Baza danych: `phpmysql-1`
-- Pierwsza z dwóch baz danych
-- --------------------------------------------------------

--
-- Struktura tabeli `publikacje`
--

CREATE TABLE `publikacje` (
  `id` int(11) NOT NULL,
  `tytul` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `podsumowanie` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tresc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `utworzono` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `id_kategorii` int(11) NOT NULL,
  `id_uczestnika` int(11) NOT NULL,
  `id_obrazu` int(11) DEFAULT NULL,
  `opublikowano` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Zrzut danych tabeli `publikacje`
--

INSERT INTO `publikacje` (`id`, `tytul`, `podsumowanie`, `tresc`, `utworzono`, `id_kategorii`, `id_uczestnika`, `id_obrazu`, `opublikowano`) VALUES
(1, 'Broszura Systemic', 'Projekt broszury na festiwal naukowy', 'Ta broszura jest częścią zestawu materiałów reklamowych promujących festiwal nauki Systemic. Materiały te charakteryzują się złożoną szatą graficzną, będącą abstrakcyjną siatką ścieżek reprezentujących wybór i podejmowanie decyzji w tworzeniu złożonych systemów.', '2021-01-26 12:21:03', 1, 2, 1, 1),
(2, 'Prognoza', 'Ilustracja dla magazynu o modzie', 'Ilustracja została zamówiona przez magazyn o modzie na potrzeby artykułu o przyszłych trendach. W projekcie wykorzystano luksusowe torebki, które naśladują chmury przypominające symbolikę stosowaną w prognozach pogody. Zastosowane powtórzenia i schematy podkreślają moc prognoz.', '2021-01-28 19:44:03', 3, 2, 2, 1),
(3, 'Basen', 'Zdjęcie do magazynu architektonicznego', 'To zdjęcie jest jednym z serii zamówionych do artykułu w czasopiśmie architektonicznym, w którym zaprezentowano baseny w prywatnych rezydencjach. Estetyka różnorodnych lokalizacji nawiązywała do połowy ubiegłego wieku. Zdjęcia zostały zrobione na ziarnistym, czarno-białym filmie fotograficznym.', '2021-02-02 09:45:52', 4, 1, 3, 1),
(4, 'Chodzące ptaki', 'Projekt do teledysku', 'Założeniem tego teledysku było połączenie psychodelicznego klimatu lat sześćdziesiątych z chropawą estetyką z lat siedemdziesiątych i ukazanie tego przez pryzmat animacji w stylu Ulicy Sezamkowej. Dzięki ponad dwóm milionom wyświetleń online grafika z powodzeniem promowała piosenkę w wielu kanałach mediów społecznościowych.', '2021-02-12 11:05:35', 3, 3, 4, 1),
(5, 'Siostry', 'Ilustracja do artykułu o psychologii', 'Artykuł, któremu towarzyszą te ilustracje, zwraca uwagę na zmieniający się krajobraz powiązań rodzinnych w dzisiejszych czasach w porównaniu do obrazu sytuacji sprzed półwiecza. Celem było zobrazowanie rozpadających się więzi międzyludzkich wskutek rosnącego rozproszenia społeczności na całym globie.', '2021-02-26 15:31:16', 3, 3, NULL, 1),
(6, 'Mikrowydmy', 'Fotografia do czasopisma naukowego', 'Fotografia ta została zamówiona jako ilustracja do artykułu naukowego o małych ekosystemach w środowisku przybrzeżnym. Ze względu na miniaturową skalę tematu, do uchwycenia drobnych szczegółów użyto obiektywu makro. Zdjęcia powstały na północnym wybrzeżu Australii.', '2021-03-02 21:02:47', 4, 1, 6, 1),
(7, 'Strona Milk Beach', 'Strona albumu muzycznego', 'Ta oparta na zdjęciach wykorzystanych do zaprojektowania okładki albumu strona udostępnia użytkownikom wygodne narzędzia do odsłuchiwania muzyki cyfrowej. Zadbano o to, by fani mogli bliżej poznać swój ulubiony zespół i byli informowani o premierach nowych płyt i utworów.', '2021-03-06 10:16:22', 2, 1, 7, 1),
(8, 'Aplikacja Wellness', 'Aplikacja dla placówki zdrowia', 'Sieć placówek służby zdrowia Wellness wymagała aplikacji, która umożliwiałaby członkom przeglądanie i rezerwowanie zajęć. Na podstawie księgi marki opracowano wygląd witryny z zachowaniem sugerowanego, minimalistycznego stylu.', '2021-03-12 14:45:49', 2, 2, 8, 1),
(9, 'Milk Beach Music', 'Zdjęcia do serii albumów muzycznych', 'Wytwórnia muzyczna, która wydała tę serię, chciała uchwycić plażę, która zainspirowała jej stworzenie. Wiele zdjęć (w tym widoki panoramiczne i zbliżenia) wykonano na miejscu w Milk Beach w Sydney w Australii. W postprodukcji nadano im wygląd bichromii.', '2021-03-12 17:09:40', 4, 1, 9, 1),
(10, 'Mural Polite Society', 'Wielkoformatowe ilustracje dla producenta odzieży', 'To jedna z kilku ilustracji zamówionych przez firmę Polite Society do dekoracji ich nowej kolekcji jesienno-zimowej. Odzwierciedlają one nowoczesną estetykę najnowszej kolekcji i są przystosowane do wykorzystania w różnych formach (takich jak murale, wizualizacje cyfrowe i poligrafia).', '2021-03-16 14:14:40', 3, 1, 10, 1),
(11, 'Strona i aplikacja Stargazer', 'Strona internetowa i aplikacja dla festiwalu muzycznego', 'Witryna festiwalu muzycznego Stargazer opiera się przede wszystkim na estetycznej typografii i zawiera informacje o występach znanych wykonawców. Umożliwia użytkownikom przeglądanie harmonogramu festiwalu i zakup biletów, a także planować przyjazd i rezerwować posiłki.', '2021-03-17 18:01:19', 2, 3, 11, 1),
(12, 'The Ice Palace', 'Projekt okładki', 'Okładka reedycji klasycznej norweskiej powieści „The Ice Palace” wydanej nakładem Chimney Press. Grafika odzwierciedla zwięzły styl i poczucie niepokoju, którym nasycona jest powieść i sam zdaje się uwięziony w okowach lodu. Książkę wydano w płóciennej oprawie, a gruba okładka skrywa jej mroźne tajemnice.', '2021-03-20 11:24:52', 1, 2, 12, 1),
(13, 'Strona Chimney Press', 'Strona internetowa wydawcy książek', 'Projekt powstał na podstawie szeroko zakrojonych badań nad postrzeganiem wizerunku marki Chimney Press w wielu kanałach. Zebrane informacje pokazały, że klienci chcą być na bieżąco informowani o premierach i zapowiedziach, a także udostępniać te informacje w swoich sieciach społecznościowych.', '2021-03-21 08:44:01', 2, 2, 13, 1),
(14, 'Okładka albumu Milk Beach', 'Okładka albumu muzycznego', 'Okładka, opracowana na podstawie formacji skalnych zdobiący tytułowy rejon Milk Beach, tworzy piękny i pogodny kontekst dla niezwykle udanej serii nagrań. W tym projekcie wykorzystano karton pochodzący z recyklingu i nadano mu subtelną kolorystykę.', '2021-03-27 13:15:20', 1, 1, 14, 1),
(15, 'Morski pejzaż', 'Zdjęcie na wystawę sztuki', 'To ujęcie morza w Margate było częścią wystawy zbiorowej w galerii sztuki Turner Contemporary Art w hrabstwie Kent w Anglii. Wydrukowany w dużej skali, wyciszający pejzaż odsłania ponadczasowe piękno słonych wód, które od wieków przyciągają londyńczyków.', '2021-04-03 20:36:08', 4, 2, 15, 1),
(16, 'Strona Polite Society', 'Strona producenta odzieży', 'Witryna Polite Society została przebudowana od podstaw na podstawie spostrzeżeń zaczerpniętych z jej starej wersji i dostosowana do wymogów dzisiejszego użytkownika. Zadbano o możliwość dostosowania strony do wielu urządzeń i stworzono nowy back-end, uwzględniający wymogi związane z przyszłym rozwojem firmy.', '2021-04-06 11:21:44', 2, 1, 16, 1),
(17, 'Snow Search', 'Grafika do gry mobilnej', 'Te ilustracje przedstawiające młodego chłopca i jego psa stały się kanwą dla bardzo udanej gry animowanej o nazwie Snow Search. Gra, która została zaprojektowana na urządzenia mobilne, otrzymała kilka nagród za projekt i mechanikę. Obecnie trwają prace nad ilustracjami do kontynuacji.', '2021-04-08 09:46:31', 3, 3, 17, 1),
(18, 'Strona kwiaciarni', 'Strona internetowa dla kwiaciarni', 'Kwiaciarnia z Brooklynu potrzebowała nowoczesnej witryny internetowej, wspierającej rosnący zakres usług. Współpracując ze stylistą i fotografem, stworzyliśmy przyjemną i prostą w obsłudze witrynę. Od czasu ponownego uruchomienia strony liczba zapytań online znacznie wzrosła.', '2021-04-08 18:05:19', 2, 1, 18, 1),
(19, 'Upadek przemysłu', 'Fotografia do magazynu', 'To zdjęcie starego sprzętu przemysłowego w nieużywanym doku stanowiło ilustrację do eseju w czasopiśmie o urbanistyce i rewitalizacji. Istotą projektu było dostrzeżenie wizualnego piękna tkwiącego w rozpadzie i zainspirowanie czytelników do postępowania zgodnie z zasadami zrównoażonego rozwoju.', '2021-04-11 11:52:02', 4, 2, 19, 1),
(20, 'Wizytówki Chimney Press', 'Projekt wizytówek dla wydawnictwa', 'Oprócz kilku innych elementów identyfikacji wizualnej, firma Chimney Press potrzebowała nowych wizytówek dla powiększającego się personelu biurowego. Zgodnie z misją firmy opierającej się na reedycjach starszych tytułów, podstawą nowoczesnego projektu była czysta i inspirowana stylem vintage estetyka.', '2021-04-15 10:04:39', 1, 2, 20, 1),
(21, 'Stargazer', 'Ilustracje na festiwal muzyczny', 'Seria ilustracji zamówiona na potrzeby materiałów promocyjnych festiwali muzycznych Stargazer. W odróżnieniu od lat poprzednich, w tym roku postanowiono nie eksponować nocnego nieba, lecz skupić się na pięknie i zadziwieniu patrzących w gwiazdy.', '2021-04-19 19:08:11', 3, 3, 21, 1),
(22, 'Plakaty Polite Society', 'Plakaty dla firmy odzieżowej', 'Plakaty te powstały z myślą o zwiększeniu świadomości marki w świecie mody w ramach międzynarodowej kampanii przed nadchodzącym sezonem jesienno-zimowym. Klient wymagał czegoś estetycznie nowoczesnego, odzwierciedlającego żywą paletę barw nowej kolekcji.', '2021-04-22 08:49:27', 1, 1, 22, 1),
(23, 'Golden Brown', 'Fotografia do książki wnętrzarskiej', 'To zdjęcie jest jednym z kilku zamieszczonych w książce Golden Brown, poświęconej projektowaniu wnętrz. Zaprezentowane w niej wnętrza pokazują aktualny trend powrotu do lat 70., a kolorystyka fotografii odzwierciedla ich ciepłą paletę barw w odcieniach ziemi.', '2021-04-25 13:51:19', 4, 3, 23, 1),
(24, 'Przewodnik turystyczny', 'Projekt graficzny serii przewodników turystycznych', 'Bestsellerowa seria przewodników turystycznych Featherview wymagała odświeżenia wyglądu i stylu ich najnowszej serii książek dotyczących Azji. Wydawca szukał czystego i prostego rozwiązania - uniwersalnego projektu, w którym odnajdzie się bywalec kawiarni i backpacker.', '2021-04-25 20:11:42', 1, 1, 24, 1);

-- --------------------------------------------------------

--
-- Struktura tabeli `kategorie`
--

CREATE TABLE `kategorie` (
  `id` int(11) NOT NULL,
  `nazwa` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `opis` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nawigacja` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Zrzut danych tabeli `kategorie`
--

INSERT INTO `kategorie` (`id`, `nazwa`, `opis`, `nawigacja`) VALUES
(1, 'Druk', 'Inspirujące projekty poligraficzne', 1),
(2, 'Digital', 'Potęga pikseli', 1),
(3, 'Ilustracja', 'Opowieści rysowane kreską', 1),
(4, 'Fotografia', 'Uchwycić chwilę', 1);

-- --------------------------------------------------------

--
-- Struktura tabeli `obrazy`
--

CREATE TABLE `obrazy` (
  `id` int(11) NOT NULL,
  `plik` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Zrzut danych tabeli `obrazy`
--

INSERT INTO `obrazy` (`id`, `plik`, `alt`) VALUES
(1, 'systemic-brochure.jpg', 'Broszura dla festiwalu naukowego Systemic'),
(2, 'forecast.jpg', 'Ilustracja torebki'),
(3, 'swimming-pool.jpg', 'Zdjęcie basenu'),
(4, 'birds.jpg', 'Kolaż z dwoma ptakami'),
(5, 'sisters.jpg', 'Dwie siostry'),
(6, 'micro-dunes.jpg', 'Zdjęcie malutkich wydm'),
(7, 'milk-beach.jpg', 'Serwis Milk Beach'),
(8, 'wellness.jpg', 'Harmonogram jogi dla sieci Wellness'),
(9, 'milk-beach-skyline.jpg', 'Zdjęcie portu w Sydney zrobione z Milk Beach'),
(10, 'polite-society-mural.jpg', 'Mural dla Polite Society'),
(11, 'stargazer.jpg', 'Projekt dla strony Stargazer'),
(12, 'the-ice-palace.jpg', 'Okładka książki The Ice Palace'),
(13, 'chimney.jpg', 'Strona Chimney Press'),
(14, 'milk-beach-album.jpg', 'Okładka płyty winylowej dla Milk Beach'),
(15, 'seascape.jpg', 'Zdjęcie morza z Margate Beach'),
(16, 'polite-society.jpg', 'Strona Polite Society'),
(17, 'snow-search.jpg', 'Ilustracja chłopca w śniegu'),
(18, 'floral.jpg', 'Strona dla kwiaciarni'),
(19, 'abandoned.jpg', 'Zdjęcie wycofanych z eksploatacji żurawi dokowych'),
(20, 'chimney-cards.jpg', 'Wizytówki dla Chimney Press'),
(21, 'stargazer-mascot.jpg', 'Ilustracja dziewczynki patrzącej w niebo'),
(22, 'polite-society-posters.jpg', 'Zdjęcie trzech plakatów dla Polite Society'),
(23, 'golden-brown.jpg', 'Zdjęcie wnętrza kawiarni'),
(24, 'featherview.jpg', 'Dwie strony z przewodnika pokazujące zamek Nijo');

-- --------------------------------------------------------

--
-- Struktura tabeli `uczestnicy`
--

CREATE TABLE `uczestnicy` (
  `id` int(11) NOT NULL,
  `imie` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nazwisko` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `haslo` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dolaczyl` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `zdjecie` varchar(254) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Zrzut danych tabeli `uczestnicy`
--

INSERT INTO `uczestnicy` (`id`, `imie`, `nazwisko`, `email`, `haslo`, `dolaczyl`, `zdjecie`) VALUES
(1, 'Sara', 'Miła', 'sara@eg.link', 'c63j-82ve-2sv9-qlb38', '2021-01-26 12:04:23', 'ivy.jpg'),
(2, 'Luke', 'Wood', 'luke@eg.link', 'saq8-2f2k-3nv7-fa4k', '2021-01-26 12:15:18', NULL),
(3, 'Emiko', 'Ito', 'emi@eg.link', 'sk3r-vd92-3vn1-exm2', '2021-02-12 10:53:47', 'emi.jpg');

--
-- Indeksy dla zrzuconych tabel
--

--
-- Indeksy dla tabeli `publikacje`
--
ALTER TABLE `publikacje`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `tytul` (`tytul`),
  ADD KEY `id_kategorii` (`id_kategorii`),
  ADD KEY `id_autora` (`id_uczestnika`),
  ADD KEY `id_obrazu` (`id_obrazu`);

--
-- Indeksy dla tabeli `kategorie`
--
ALTER TABLE `kategorie`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `nazwa` (`nazwa`);

--
-- Indeksy dla tabeli `obrazy`
--
ALTER TABLE `obrazy`
  ADD PRIMARY KEY (`id`);

--
-- Indeksy dla tabeli `uczestnicy`
--
ALTER TABLE `uczestnicy`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT dla zrzuconych tabel
--

--
-- AUTO_INCREMENT dla tabeli `publikacje`
--
ALTER TABLE `publikacje`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=25;

--
-- AUTO_INCREMENT dla tabeli `kategorie`
--
ALTER TABLE `kategorie`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT dla tabeli `obrazy`
--
ALTER TABLE `obrazy`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=25;

--
-- AUTO_INCREMENT dla tabeli `uczestnicy`
--
ALTER TABLE `uczestnicy`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- Ograniczenia dla zrzuconych tabel
--

--
-- Ograniczenia dla tabeli `publikacje`
--
ALTER TABLE `publikacje`
  ADD CONSTRAINT `kategorie_exists` FOREIGN KEY (`id_kategorii`) REFERENCES `kategorie` (`id`),
  ADD CONSTRAINT `image_exists` FOREIGN KEY (`id_obrazu`) REFERENCES `obrazy` (`id`),
  ADD CONSTRAINT `member_exists` FOREIGN KEY (`id_uczestnika`) REFERENCES `uczestnicy` (`id`);
