<?php
// FUNKCJA OBSŁUGUJĄCA BAZĘ DANYCH
function pdo(PDO $pdo, string $sql, array $argumenty = null)
{
    if (!$argumenty) {                   // Jeśli nie ma parametrów zapytania
        return $pdo->query($sql);        // Uruchom zapytanie i zwróć obiekt PDOStatement
    }
    $instrukcja = $pdo->prepare($sql);   // Jeśl zapytanie ma parametry przygotujje
    $instrukcja->execute($argumenty);    // Wykonaj instrukcję
    return $instrukcja;                  // Zwróć obiekt PDOStatement
}

// FUNKCJE FORMATUJĄCE
function zastap_html($tekst): string
{
	$tekst = $tekst ?? '';
    return htmlspecialchars($tekst, ENT_QUOTES, 'UTF-8', false); // Zwróć przetworzony tekst
}

function formatuj_date(string $string): string
{
    $data = date_create_from_format('Y-m-d H:i:s', $string);   // Przekształć w obiekt DateTime
    return $data->format('d F Y');                             // Zwróć datę w formacie dzień miesiąc rok
}

// FUNKCJE POMOCNICZE
function przekieruj(string $lokalizacja, array $parametry = [], $kod_odpowiedzi = 302)
{
    $zap = $parametry ? '?' . http_build_query($parametry) : '';  // Utwórz łańcuch zapytania URL
    $lokalizacja = $lokalizacja . $zap;                           // UTwórz nową ścieżkę
    header('Location: ' . $lokalizacja, $kod_odpowiedzi);         // Przekieruj na nową stronę
    exit;                                                         // Przerwij wykonywanie kodu
}

function utworz_nazwepliku(string $nazwapliku, string $sciezka_docelowa): string
{
    $nazwa  = pathinfo($nazwapliku, PATHINFO_FILENAME);           // Pobierz nazwę pliku
    $rozszerzenie = pathinfo($nazwapliku, PATHINFO_EXTENSION);    // Pobierz rozszerzenie
    $czystanazwa = preg_replace("/[^A-z0-9]/", "-", $nazwa);      // Oczyść nazwę pliku
    $nazwapliku  = $czystanazwa . '.' . $rozszerzenie;            // Miejsce docelowe
    $i         = 0;                                               // Licznik
    while (file_exists($sciezka_docelowa . $nazwapliku)) {        // Jeśli plik istnieje
        $i        = $i + 1;                                       // Zaktualizuj licznik
        $nazwapliku = $nazwa . $i . '.' . $rozszerzenie;          // Nowa nazwa pliku
    }
    return $nazwapliku;                                           // Return filename
}

// FUNKCJE OBSŁUGUJĄCE BŁĘDY I WYJĄTKI
// Przekształć błędy w wyjątki
set_error_handler('obsluga_bledow');                                // Skonfiguruj obsługę błędów
function obsluga_bledow($typ, $komunikat, $plik = '', $wiersz = 0)
{
    throw new ErrorException($komunikat, 0, $typ, $plik, $wiersz);  // Wyrzuć obiekt ErrorException
}

// Obsłuż wyjątki - zapisz je w logu i wyświetl komunikat błędu, jeśli serwer nie przejdzie na stronę podaną w .htaccess
set_exception_handler('obsluga_wyjatkow');                         // Skonfiguruj obsługę wyjątków
function obsluga_wyjatkow($e)
{
    error_log($e);                                                 // Zarejestruj błąd
    http_response_code(500);                                       // Ustaw kod odpowiedzi
    echo "<h1>Przepraszamy za usterki.</h1>
          <p>Administratorzy strony zostali poinformowani o problemie. Prosimy spróbować później.</p>";
}

// Obsługa błędów krytycznych
register_shutdown_function('obsluga_zamkniecia');                   // Skonfiguruj obsługę zamknięcia
function obsluga_zamkniecia()
{
    $blad = error_get_last();                                       // Czy w skrypcie był błąd?
    if ($blad) {                                                    // Jeśli tak, wyrzuć wyjątek
        $e = new ErrorException($blad['message'], 0, $blad['type'],
                                $blad['file'], $blad['line']);
        obsluga_wyjatkow($e);                                       // Wywołaj funkcję obsługi wyjątków
    }
}