<?php
$przeniesiono      = false;                                        // Inicjalizacja
$komunikat         = '';                                           // Inicjalizacja
$blad              = '';                                           // Inicjalizacja
$sciezka_docelowa  = 'wyslane/';                                   // Docelowa ścieżka
$max_rozmiar       = 5242880;                                      // Maksymalny rozmiar pliku
$dozwolone_typy    = ['image/jpeg', 'image/png', 'image/gif',];    // Dozwolone typy plików
$dozwolone_roz     = ['jpeg', 'jpg', 'png', 'gif',];               // Dozwolone rozszerzenia

function utworz_nazwepliku($nazwapliku, $sciezka_docelowa)         // Funkcja tworząca nazwę pliku
{
    $nazwa   = pathinfo($nazwapliku, PATHINFO_FILENAME);           // Pobierz nazwę
    $rozszerzenie  = pathinfo($nazwapliku, PATHINFO_EXTENSION);    // Pobierz rozszerzenie
    $nazwa   = preg_replace('/[^A-z0-9]/', '-', $nazwa);           // Oczyść nazwę
	$nazwapliku   = $nazwa . '.' . $rozszerzenie;                  // Dodaj rozszerzenie do oczyszczonej nazwy pliku
    $i          = 0;                                               // Licznik
    while (file_exists($sciezka_docelowa . $nazwapliku)) {         // Jeśli plik istnieje...
        $i        = $i + 1;                                        // Zaktualizuj licznik
        $nazwapliku = $nazwa . $i . '.' . $rozszerzenie;           // Nowa ścieżka
    }
    return $nazwapliku;                                            // Zwróć ścieżkę
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                        // Jeśli formularz został przesłany
    $blad = ($_FILES['obraz']['error'] === 1) ? 'za duży ' : '';   // Sprawdź obraz pod kątem rozmiaru

    if ($_FILES['obraz']['error'] == 0) {                          // Jeśli nie ma błędów
        $blad  .= ($_FILES['obraz']['size'] <= $max_rozmiar) ? '' : 'za duży '; // Sprawdź rozmiar
        // Sprawdź typ MIME w tablicy $dozwolone_typy
        $typ   = mime_content_type($_FILES['obraz']['tmp_name']);        
        $blad .= in_array($typ, $dozwolone_typy) ? '' : 'nieobsługiwany typ ';
        // Sprawdź rozszerzenie w tablicy $dozwolone_roz
        $roz    = strtolower(pathinfo($_FILES['obraz']['name'], PATHINFO_EXTENSION));
        $blad .= in_array($roz, $dozwolone_roz) ? '' : 'nieobsługiwane rozszerzenie ';

        // Jeśli nie ma błędów, utwórz nową ścieżkę i spróbuj przenieść plik
        if (!$blad) {
          $nazwapliku    = utworz_nazwepliku($_FILES['obraz']['name'], $sciezka_docelowa);
          $docelowy = $sciezka_docelowa . $nazwapliku;
          $przeniesiono       = move_uploaded_file($_FILES['obraz']['tmp_name'], $docelowy);
        }
    }
    if ($przeniesiono === true) {                                     // Jeśli został przeniesiony
        $komunikat = 'Przesłano:<br><img src="' . $docelowy . '">';   // Wyświetl obraz
    } else {                                                          // W przeciwnym razie
        $komunikat = '<b>Nie udało się przesłać pliku:</b> ' . $blad; // Wyświetl błędy
    }
}
?>
<?php include 'dolaczane/naglowek.php' ?>
<?= $komunikat ?>
  <form method="POST" action="sprawdzanie-pliku.php" enctype="multipart/form-data">
    <label for="obraz"><b>Prześlij plik:</b></label>
    <input type="file" name="obraz" id="obraz"><br>
    <input type="submit" value="Wyślij">
  </form>
<?php include 'dolaczane/stopka.php' ?>